<?php
require_once '../includes/bootstrap.php';
header('Content-Type: application/json');

$response = ['success' => false, 'message' => 'Acción no válida.'];

if ($_SERVER["REQUEST_METHOD"] !== "POST") {
    $response['message'] = 'Acceso denegado.';
    echo json_encode($response);
    exit();
}

if (!isset($_SESSION['csrf_token']) || !isset($_POST['csrf_token'])) {
    $response['message'] = 'Tu sesión ha expirado. Reintentando automáticamente...';
    $response['error_code'] = 'SESSION_EXPIRED';
    echo json_encode($response);
    exit();
}

if (!hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
    $response['message'] = 'Error de seguridad. Por favor, refresca la página e intenta de nuevo.';
    echo json_encode($response);
    exit();
}

$usuario = trim($_POST['usuario']);
$password = $_POST['password'];
$force_login = isset($_POST['force_login']) && $_POST['force_login'] === 'true';

if (empty($usuario) || empty($password)) {
    $response['message'] = 'El usuario y la contraseña no pueden estar vacíos.';
    echo json_encode($response);
    exit();
}

try {
    $stmt = $conn->prepare("SELECT id, usuario, password, nombre, rol_id, estado FROM usuarios WHERE usuario = ? LIMIT 1");
    $stmt->execute([$usuario]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($user) {
        if (password_verify($password, $user['password'])) {
            if ($user['estado'] == 1) {
                // --- NUEVA LÓGICA DE VERIFICACIÓN DE SESIÓN ACTIVA ---
                $stmt_check_active = $conn->prepare("SELECT session_id, ip_address, last_activity FROM sesiones_activas WHERE usuario_id = ? AND is_active = 1 LIMIT 1");
                $stmt_check_active->execute([$user['id']]);
                $active_session = $stmt_check_active->fetch(PDO::FETCH_ASSOC);

                if ($active_session && !$force_login) {
                    // Hay una sesión activa. ¿Es fantasma?
                    $last_activity_timestamp = strtotime($active_session['last_activity']);
                    $inactivity_period = time() - $last_activity_timestamp;

                    if ($inactivity_period > 3600) { // Más de 60 minutos de inactividad
                        // Es una sesión fantasma, la ignoramos y procedemos a loguear normalmente.
                    } else {
                        // Es una sesión activa reciente, pedimos confirmación al usuario.
                        $response['success'] = false;
                        $response['error_code'] = 'SESSION_ALREADY_ACTIVE';
                        $response['message'] = 'Ya tienes una sesión activa.';
                        $response['session_details'] = [
                            'ip' => $active_session['ip_address'],
                            'last_activity' => $active_session['last_activity']
                        ];
                        echo json_encode($response);
                        exit();
                    }
                }

                // --- PROCEDER CON EL LOGIN (FORZADO, NORMAL O TRAS IGNORAR SESIÓN FANTASMA) ---
                
                $stmt_invalidate = $conn->prepare("UPDATE sesiones_activas SET is_active = 0 WHERE usuario_id = ?");
                $stmt_invalidate->execute([$user['id']]);

                session_regenerate_id(true);
                $new_session_id = session_id();

                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_nombre'] = $user['nombre'];
                $_SESSION['user_rol_id'] = $user['rol_id'];
                $_SESSION['last_activity'] = time();
                
                // Cargar permisos y sedes... (código existente)
                $stmt_sedes = $conn->prepare("SELECT sede_id FROM usuario_sede WHERE usuario_id = ?");
                $stmt_sedes->execute([$user['id']]);
                $_SESSION['sedes_accesibles'] = $stmt_sedes->fetchAll(PDO::FETCH_COLUMN);
                
                $stmt_permisos = $conn->prepare("
                    SELECT p.clave FROM permisos p JOIN rol_permiso rp ON p.id = rp.permiso_id WHERE rp.rol_id = ?
                    UNION
                    SELECT p.clave FROM permisos p JOIN usuario_permiso up ON p.id = up.permiso_id WHERE up.usuario_id = ?
                ");
                $stmt_permisos->execute([$user['rol_id'], $user['id']]);
                $_SESSION['permisos'] = $stmt_permisos->fetchAll(PDO::FETCH_COLUMN);
                
                unset($_SESSION['csrf_token']);

                $ip_address = $_SERVER['REMOTE_ADDR'];
                $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? 'N/A';
                $fecha_actual_vzla = date('Y-m-d H:i:s');

                $stmt_new_session = $conn->prepare(
                    "INSERT INTO sesiones_activas (session_id, usuario_id, ip_address, user_agent, last_activity, is_active, estado) 
                     VALUES (?, ?, ?, ?, ?, 1, 'activa')"
                );
                $stmt_new_session->execute([$new_session_id, $user['id'], $ip_address, $user_agent, $fecha_actual_vzla]);
                
                $detalle_log = "Login exitoso desde la IP: {$ip_address}";
                registrar_accion_login($conn, $user['id'], $new_session_id, 'login_exitoso', $detalle_log, $ip_address);

                $response = ['success' => true, 'redirectUrl' => 'administracion/inicio.php'];

            } else {
                $response['message'] = 'Tu usuario está desactivado.';
            }
        } else {
            $ip_address = $_SERVER['REMOTE_ADDR'];
            $detalle_log = "Intento de login fallido para el usuario '{$usuario}' desde la IP: {$ip_address}";
            $user_id_log = $user ? $user['id'] : null;
            registrar_accion_login($conn, $user_id_log, session_id(), 'login_fallido', $detalle_log, $ip_address);
            
            $response['message'] = 'Contraseña incorrecta.';
        }
    } else {
        $response['message'] = 'Usuario no encontrado.';
    }
    
} catch (PDOException $e) {
    error_log($e->getMessage());
    $response['message'] = 'Error con la base de datos.';
}

// Función auxiliar para registrar logs antes de que cargue seguridad.php
function registrar_accion_login($conn, $usuario_id, $session_id, $accion, $detalle, $ip_address) {
    try {
        $stmt = $conn->prepare( "INSERT INTO bitacora_actividad (usuario_id, session_id, accion, detalle, ip_address, fecha) VALUES (?, ?, ?, ?, ?, NOW())" );
        $stmt->execute([$usuario_id, $session_id, $accion, $detalle, $ip_address]);
    } catch (PDOException $e) {
        error_log("Error al registrar en bitácora desde login: " . $e->getMessage());
    }
}

echo json_encode($response);