<?php
define('IS_AJAX', true);
require_once '../administracion/includes/seguridad.php';

header('Content-Type: application/json');
$response = ['success' => false, 'message' => 'Acción no válida.'];

if (!puede('monitorear_sesiones')) {
    $response['message'] = 'Acceso denegado.';
    echo json_encode($response);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
        $response['message'] = 'Error de seguridad (CSRF).';
        echo json_encode($response);
        exit();
    }
}

$action = $_POST['action'] ?? $_GET['action'] ?? '';

switch ($action) {
    case 'obtener_resumen_usuarios':
        try {
            // Consulta mejorada: Se une con sesiones_activas para ver quién tiene una sesión activa (is_active = 1)
            $resumen_usuarios = $conn->query("
                SELECT 
                    u.id, 
                    u.nombre, 
                    r.nombre as rol_nombre,
                    -- Contamos si existe al menos una sesión con is_active = 1 para este usuario
                    (SELECT COUNT(*) FROM sesiones_activas sa WHERE sa.usuario_id = u.id AND sa.is_active = 1) as sesion_activa,
                    (SELECT MAX(last_activity) FROM sesiones_activas sa WHERE sa.usuario_id = u.id) as ultima_actividad_general
                FROM usuarios u
                LEFT JOIN roles r ON u.rol_id = r.id
                ORDER BY u.nombre ASC
            ")->fetchAll(PDO::FETCH_ASSOC);

            $response = ['success' => true, 'data' => $resumen_usuarios];
        } catch (PDOException $e) {
            $response['message'] = 'Error al obtener resumen de usuarios.';
            error_log($e->getMessage());
        }
        break;

    case 'obtener_detalles_usuario':
        $usuario_id = filter_input(INPUT_GET, 'usuario_id', FILTER_VALIDATE_INT);
        if ($usuario_id) {
            // La consulta ahora trae TODAS las sesiones, ordenando la activa de primero.
            $stmt_sesiones = $conn->prepare("
                SELECT * FROM sesiones_activas 
                WHERE usuario_id = ? 
                ORDER BY is_active DESC, last_activity DESC 
                LIMIT 20
            ");
            $stmt_sesiones->execute([$usuario_id]);
            $sesiones = $stmt_sesiones->fetchAll(PDO::FETCH_ASSOC);

            $stmt_bitacora = $conn->prepare("SELECT * FROM bitacora_actividad WHERE usuario_id = ? ORDER BY fecha DESC LIMIT 50");
            $stmt_bitacora->execute([$usuario_id]);
            $bitacora = $stmt_bitacora->fetchAll(PDO::FETCH_ASSOC);
            
            // --- MANTENEMOS LA LÓGICA DE GEOLOCALIZACIÓN POR IP ---
            $ips_consultadas = [];
            foreach ($bitacora as &$entrada) {
                $ip = $entrada['ip_address'];
                if (!empty($ip) && !isset($ips_consultadas[$ip])) {
                    // Usamos un timeout corto para no ralentizar la carga si la API no responde
                    $context = stream_context_create(['http' => ['timeout' => 2]]);
                    $geo_data = @file_get_contents("http://ip-api.com/json/{$ip}?fields=city,country", false, $context);
                    if ($geo_data) {
                        $geo = json_decode($geo_data, true);
                        if ($geo && !empty($geo['city'])) {
                            $ips_consultadas[$ip] = ($geo['city'] ?? 'N/A') . ', ' . ($geo['country'] ?? 'N/A');
                        } else {
                            $ips_consultadas[$ip] = 'Ubicación privada o no disponible';
                        }
                    } else {
                        $ips_consultadas[$ip] = 'No se pudo obtener la ubicación';
                    }
                }
                $entrada['ubicacion'] = $ips_consultadas[$ip] ?? 'N/A';
            }
            unset($entrada);

            $response = ['success' => true, 'data' => ['sesiones' => $sesiones, 'bitacora' => $bitacora]];
        }
        break;

    case 'cerrar_sesion_remota':
        $session_id = $_POST['session_id'] ?? '';
        if (!empty($session_id)) {
            // El cierre remoto ahora desactiva y marca como 'cerrada'.
            $stmt = $conn->prepare("UPDATE sesiones_activas SET estado = 'cerrada', is_active = 0 WHERE session_id = ?");
            $stmt->execute([$session_id]);
            registrar_accion('cierre_sesion_remoto', "Cerró la sesión con ID: {$session_id}");
            $response = ['success' => true, 'message' => 'La sesión ha sido marcada para cierre. El usuario será desconectado en su próxima acción.'];
        } else {
            $response['message'] = 'ID de sesión no proporcionado.';
        }
        break;
}

echo json_encode($response);