<?php
define('IS_AJAX', true); // Le decimos al sistema que este es un archivo AJAX
require_once '../administracion/includes/seguridad.php';

header('Content-Type: application/json');
$response = ['success' => false, 'message' => 'Acción no válida.'];

// Seguridad: Solo Super Administradores pueden gestionar roles
if ($_SESSION['rol_clave'] !== 'superadmin') {
    $response['message'] = 'Acceso denegado.';
    echo json_encode($response);
    exit();
}

// Verificación CSRF solo para acciones POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
        $response['message'] = 'Error de seguridad (CSRF).';
        echo json_encode($response);
        exit();
    }
}

$action = $_POST['action'] ?? $_GET['action'] ?? '';

switch ($action) {
    case 'obtener_permisos_rol':
        $rol_id = filter_input(INPUT_GET, 'rol_id', FILTER_VALIDATE_INT);
        if ($rol_id) {
            // Obtener todos los permisos disponibles
            $stmt_todos = $conn->query("SELECT id, clave, descripcion FROM permisos ORDER BY clave ASC");
            $todos_permisos = $stmt_todos->fetchAll(PDO::FETCH_ASSOC);

            // Obtener los permisos que este rol ya tiene
            $stmt_rol = $conn->prepare("SELECT permiso_id FROM rol_permiso WHERE rol_id = ?");
            $stmt_rol->execute([$rol_id]);
            $permisos_actuales = $stmt_rol->fetchAll(PDO::FETCH_COLUMN);

            $response = [
                'success' => true,
                'data' => [
                    'todos_permisos' => $todos_permisos,
                    'permisos_actuales' => $permisos_actuales
                ]
            ];
        } else {
            $response['message'] = 'ID de rol no válido.';
        }
        break;

    case 'guardar_permisos_rol':
        $rol_id = filter_input(INPUT_POST, 'rol_id', FILTER_VALIDATE_INT);
        $permisos = $_POST['permisos'] ?? [];

        if ($rol_id) {
            try {
                $conn->beginTransaction();

                // 1. Borrar todos los permisos antiguos de ese rol
                $stmt_delete = $conn->prepare("DELETE FROM rol_permiso WHERE rol_id = ?");
                $stmt_delete->execute([$rol_id]);

                // 2. Insertar los nuevos permisos seleccionados
                if (!empty($permisos)) {
                    $stmt_insert = $conn->prepare("INSERT INTO rol_permiso (rol_id, permiso_id) VALUES (?, ?)");
                    foreach ($permisos as $permiso_id) {
                        $stmt_insert->execute([$rol_id, $permiso_id]);
                    }
                }
                
                $conn->commit();
                $response = ['success' => true, 'message' => 'Permisos actualizados correctamente.'];

            } catch (PDOException $e) {
                $conn->rollBack();
                error_log($e->getMessage());
                $response['message'] = 'Error al guardar los permisos.';
            }
        } else {
            $response['message'] = 'ID de rol no válido.';
        }
        break;
}

echo json_encode($response);