<?php
// keep_alive.php - Renovar sesión del usuario
require_once '../administracion/includes/seguridad.php';

// El simple hecho de que seguridad.php se ejecute y no redirija
// significa que la sesión es válida y se renueva automáticamente

// ✅ Renovar explícitamente la sesión
if (isset($_SESSION['usuario_id'])) {
    $_SESSION['last_activity'] = time();
    
    // Responder exitosamente
    http_response_code(200);
    echo json_encode([
        'success' => true,
        'message' => 'Sesión renovada exitosamente',
        'usuario_id' => $_SESSION['usuario_id'],
        'timestamp' => date('Y-m-d H:i:s')
    ]);
} else {
    // Si por alguna razón no hay sesión
    http_response_code(401);
    echo json_encode([
        'success' => false,
        'message' => 'No hay sesión activa'
    ]);
}
?>