<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

define('IS_AJAX', true);
require_once '../administracion/includes/seguridad.php';

header('Content-Type: application/json');
$response = ['success' => false, 'message' => 'Acción no válida.'];
$usuario_id = $_SESSION['user_id'] ?? 0;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token']))) {
    $response['message'] = 'Error de seguridad (CSRF).';
    echo json_encode($response);
    exit();
}

$action = $_POST['action'] ?? $_GET['action'] ?? '';

switch ($action) {

    case 'cargar_rutas_activas':
        // CAMBIO: Se añade un bloque try...catch para capturar y mostrar errores de BD
        try {
            $stmt = $conn->prepare("SELECT id, nombre_ruta FROM rutas WHERE activa = '1' ORDER BY nombre_ruta ASC");
            $stmt->execute();
            $response = ['success' => true, 'data' => $stmt->fetchAll(PDO::FETCH_ASSOC)];

        } catch (PDOException $e) {
            // Si hay un error con la consulta, se enviará este mensaje al frontend
            $response['success'] = false;
            $response['message'] = 'Error al consultar la base de datos: ' . $e->getMessage();
            // Opcional: Registrar el error en un archivo de logs del servidor
            error_log("Error en cargar_rutas_activas: " . $e->getMessage());
        }
        break;

    case 'importar_jornadas':
        if (!puede('tu_permiso_aqui')) { // Asegúrate de poner el permiso correcto
            $response['message'] = 'Acceso denegado.';
            break;
        }
        
        if (!isset($_POST['ruta_id']) || empty($_POST['ruta_id'])) {
            $response['message'] = 'Debes seleccionar una ruta de destino.';
            break;
        }
        if (!isset($_FILES['archivo_jornadas']) || $_FILES['archivo_jornadas']['error'] != 0) {
            $response['message'] = 'Error al subir el archivo o no se seleccionó ninguno.';
            break;
        }

        $ruta_id = (int)$_POST['ruta_id'];
        $archivo = $_FILES['archivo_jornadas']['tmp_name'];
        $handle = fopen($archivo, "r");
        fgetcsv($handle); 

        $importados = 0;
        $fallidos = 0;
        $errores_detalle = [];
        $numero_fila = 1;
        
        try {
            $conn->beginTransaction();

            // CAMBIO DEFINITIVO: El INSERT ahora coincide 100% con tu tabla real.
            $stmt = $conn->prepare(
                "INSERT INTO jornadas (ruta_id, ciudad_nombre, fecha_jornada, estado_jornada) 
                 VALUES (?, ?, ?, 'Planificada')"
            );

            while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
                $numero_fila++;

                // CAMBIO DEFINITIVO: Ahora solo se esperan 2 columnas: Ciudad y Fecha.
                if (count($data) >= 2) {
                    $ciudad_nombre = trim($data[0]);
                    $fecha_jornada_str = trim($data[1]);

                    $fecha_obj = DateTime::createFromFormat('Y-m-d', $fecha_jornada_str);
                    if ($fecha_obj && $fecha_obj->format('Y-m-d') === $fecha_jornada_str && !empty($ciudad_nombre)) {
                        
                        // CAMBIO DEFINITIVO: Se ajustó el execute para la nueva consulta (3 parámetros).
                        $stmt->execute([$ruta_id, $ciudad_nombre, $fecha_jornada_str]);
                        $importados++;
                        
                    } else {
                        $fallidos++;
                        $errores_detalle[] = "Fila {$numero_fila}: Ciudad vacía o formato de fecha inválido. Se esperaba 'AAAA-MM-DD' pero se encontró '{$fecha_jornada_str}'.";
                    }
                } else {
                    $fallidos++;
                    $errores_detalle[] = "Fila {$numero_fila}: La fila no tiene las 2 columnas requeridas (Ciudad, Fecha).";
                }
            }
            
            $conn->commit();
            fclose($handle);

            $mensaje_final = "Importación completada. Jornadas creadas: $importados, Filas con error: $fallidos.";
            $response = ['success' => true, 'message' => $mensaje_final];
            
            if ($fallidos > 0) {
                $response['errores'] = $errores_detalle;
            }

        } catch (Exception $e) {
            if ($conn->inTransaction()) $conn->rollBack();
            if (is_resource($handle)) fclose($handle);
            $response['message'] = 'Error crítico durante la importación: ' . $e->getMessage();
            error_log("Error en importar_jornadas: " . $e->getMessage());
        }
        break;
}

echo json_encode($response);