<?php
define('IS_AJAX', true);
require_once '../administracion/includes/seguridad.php';

header('Content-Type: application/json');
$response = ['success' => false, 'message' => 'Acción no válida.'];

if (!puede('gestionar_clientes')) {
    $response['message'] = 'Acceso denegado.';
    echo json_encode($response);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
        $response['message'] = 'Error de seguridad (CSRF).';
        echo json_encode($response);
        exit();
    }
}

$action = $_POST['action'] ?? $_GET['action'] ?? '';
$usuario_id = $_SESSION['user_id'] ?? 0;

switch ($action) {
    case 'cargar_clientes':
        try {
            // Se incluye fecha_creacion en la consulta principal
            $clientes = $conn->query("SELECT id, nombre, cedula, telefono, ciudad, fecha_creacion FROM clientes ORDER BY nombre ASC")->fetchAll(PDO::FETCH_ASSOC);
            $response = ['success' => true, 'data' => $clientes];
        } catch (Exception $e) {
            $response['message'] = 'Error al cargar los clientes.';
        }
        break;

    case 'agregar_cliente':
        try {
            $stmt = $conn->prepare(
                "INSERT INTO clientes (nombre, cedula, telefono, pais, ciudad, direccion, edad, email, historial_medico_resumen, creado_por_usuario_id) 
                 VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"
            );
            $stmt->execute([
                $_POST['nombre'], $_POST['cedula'], $_POST['telefono'], $_POST['pais'], $_POST['ciudad'],
                $_POST['direccion'], $_POST['edad'] ?: null, $_POST['email'], $_POST['historial_medico_resumen'],
                $usuario_id
            ]);
            $response = ['success' => true, 'message' => 'Cliente registrado exitosamente.'];
        } catch (Exception $e) {
            $response['message'] = 'Error al registrar el cliente. La cédula ya podría existir.';
        }
        break;

    case 'obtener_cliente':
        $id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
        if ($id) {
            $stmt = $conn->prepare("SELECT * FROM clientes WHERE id = ?");
            $stmt->execute([$id]);
            $cliente = $stmt->fetch(PDO::FETCH_ASSOC);
            $response = $cliente ? ['success' => true, 'data' => $cliente] : ['message' => 'Cliente no encontrado.'];
        }
        break;

    case 'editar_cliente':
        try {
            $id = $_POST['id'];
            $stmt = $conn->prepare(
                "UPDATE clientes SET nombre=?, cedula=?, telefono=?, pais=?, ciudad=?, direccion=?, edad=?, email=?, historial_medico_resumen=?
                 WHERE id=?"
            );
            $stmt->execute([
                $_POST['nombre'], $_POST['cedula'], $_POST['telefono'], $_POST['pais'], $_POST['ciudad'],
                $_POST['direccion'], $_POST['edad'] ?: null, $_POST['email'], $_POST['historial_medico_resumen'],
                $id
            ]);
            $response = ['success' => true, 'message' => 'Cliente actualizado exitosamente.'];
        } catch (Exception $e) {
            $response['message'] = 'Error al actualizar el cliente. La cédula ya podría existir.';
        }
        break;

    default:
        $response['message'] = 'Acción desconocida.';
        break;
}

echo json_encode($response);