<?php
// La seguridad y la lógica ($activePage, $usuario_actual, puede()) ya vienen de seguridad.php
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo $_SESSION['csrf_token']; ?>">
    <title><?php echo $page_title ?? 'Ami'; ?> - Sistema de Gestión</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <link href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.12/cropper.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.12/cropper.min.js"></script>
    <link rel="stylesheet" href="/administracion/css/panel.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <style>
        /* IMPORTANTE: Estos estilos DEBEN permanecer para que funcione el scroll */
        .ami-sidebar {
            top: 60px !important; 
            height: calc(100vh - 60px) !important; 
            display: flex !important;
            flex-direction: column !important;
            position: fixed !important;
            left: 0 !important;
            width: 250px !important;
            z-index: 1040 !important;
            background-color: #101827 !important;
        }
        
        .sidebar-header {
            flex-shrink: 0 !important;
            height: 60px !important;
            padding: 10px 15px !important;
            display: flex !important;
            align-items: center !important;
            gap: 15px !important;
            background: rgba(0,0,0,0.2) !important;
        }
        
        .sidebar-menu-container {
            flex: 1 !important;
            overflow-y: auto !important;
            overflow-x: hidden !important;
            padding-bottom: 20px !important;
            scroll-behavior: smooth !important;
            /* Altura mínima para debug - si no ves scroll, aumenta este número */
            min-height: 500px !important;
        }
        
        /* Scrollbar visible para verificar que funciona */
        .sidebar-menu-container::-webkit-scrollbar {
            width: 8px !important;
            background: rgba(255, 255, 255, 0.1) !important;
        }
        
        .sidebar-menu-container::-webkit-scrollbar-thumb {
            background-color: #78E320 !important;
            border-radius: 4px !important;
        }
        
        .sidebar-menu-container::-webkit-scrollbar-thumb:hover {
            background-color: #89ff36 !important;
        }
        
        /* Para Firefox */
        .sidebar-menu-container {
            scrollbar-width: thin !important;
            scrollbar-color: #78E320 transparent !important;
        }
        
        /* Contenido principal ajustado */
        .ami-content {
            margin-left: 250px !important;
            padding: 2rem !important;
            padding-top: 80px !important;
        }
        
        /* Mobile responsive */
        @media (max-width: 768px) {
            .ami-sidebar {
                left: -250px !important;
            }
            
            .ami-page-wrapper.menu-active .ami-sidebar {
                left: 0 !important;
            }
            
            .ami-content {
                margin-left: 0 !important;
                padding: 1rem !important;
                padding-top: 80px !important;
            }
        }
        
        /* DEBUG: Borde temporal para verificar */
        .sidebar-menu-container {
            border: 1px solid rgba(120, 227, 32, 0.3) !important;
        }
    </style>
</head>
<body class="body-admin">
<div class="ami-page-wrapper" id="pageWrapper">
    <div class="ami-top-bar-mobile">
        <span class="menu-btn" onclick="toggleMenu()"><i class="fas fa-bars menu-icon"></i><i class="fas fa-times close-icon"></i></span>
        <div class="logo"><h3>Ami</h3></div>
        <div class="user-menu">
            <i class="fas fa-user-circle user-icon" onclick="toggleDropdownMobile()"></i>
            <div class="dropdown-menus" id="userDropdownMobile">
                <div class="username"><i class="fas fa-user"></i> <?php echo htmlspecialchars($usuario_actual['nombre']); ?></div>
                <a href="/includes/logout.php"><i class="fas fa-sign-out-alt"></i> Cerrar Sesión</a>
            </div>
        </div>
    </div>
    <header class="ami-header">
        <div class="header-content">
            <span class="app-name">Sistema Ami</span>
            <div class="user-menu">
                <a href="/administracion/memorandos.php" class="text-white me-3 position-relative" title="Mensajes">
                    <i class="fas fa-bell fs-5"></i>
                    <span id="notificacion-mensajes-badge" class="position-absolute top-0 start-100 translate-middle p-1 bg-danger border border-light rounded-circle" style="display: none;">
                        <span class="visually-hidden">Nuevos mensajes</span>
                    </span>
                </a>
                 <span class="user-name-desktop">Bienvenido, <?php echo htmlspecialchars($usuario_actual['nombre']); ?></span>
                <i class="fas fa-user-circle user-icon" onclick="toggleDropdownDesktop()"></i>
                <div class="dropdown-menus" id="userDropdownDesktop">
                    <a href="/includes/logout.php"><i class="fas fa-sign-out-alt"></i> Cerrar Sesión</a>
                </div>
            </div>
        </div>
    </header>
    
    <aside class="ami-sidebar" id="sideMenu">
        <div class="sidebar-header">
            <div class="profile-icon">
                <?php if (!empty($usuario_actual['foto_perfil'])): ?>
                    <img src="/uploads/perfiles/<?php echo htmlspecialchars($usuario_actual['foto_perfil']); ?>" alt="Foto" style="width: 50px; height: 50px; border-radius: 50%; object-fit: cover;" onerror="this.src='/uploads/perfiles/default.png'">
                <?php else: ?>
                    <i class="fas fa-user"></i>
                <?php endif; ?>
            </div>
            <div>
                <div class="sidebar-title">Mi Panel</div>
                <div class="sidebar-subtitle"><?php echo htmlspecialchars(ucfirst($usuario_actual['rol'])); ?></div>
            </div>
        </div>

        <div class="sidebar-menu-container">
            <?php
            // ✅ CORRECCIÓN: Verificar permisos para cada categoría (INCLUYENDO LOS FALTANTES)
            $mostrar_principal = puede('ver_dashboard');
            $mostrar_gestion_datos = puede('gestionar_clientes') || puede('gestionar_empleados_basico') || puede('gestionar_empleados_avanzado');
            
            // ✅ AQUÍ SE AÑADE EL NUEVO PERMISO PARA MOSTRAR LA CATEGORÍA DE OPERACIONES
            $mostrar_operaciones = puede('ver_agendamiento_global') || // <-- NUEVO PERMISO AÑADIDO
                                   puede('gestionar_prospectos_admin') || 
                                   puede('gestionar_rutas_admin') || 
                                   puede('ver_prospectos_operador') || 
                                   puede('ver_rutas_coordinador') ||
                                   puede('ver_dashboard_supervisor') ||
                                   puede('ver_inventario') ||      
                                   puede('gestionar_despachos') ||
                                   puede('ver_reactivacion_admin') ||
                                   puede('crear_lote_reactivacion') ||
                                   puede('ver_reactivacion_supervisor') ||
                                   puede('distribuir_lote_reactivacion') ||
                                   puede('realizar_cuadre_caja') ||
                                   puede('gestionar_afiliaciones') ||
                                   puede('ver_mis_afiliaciones') ||
                                   puede('gestionar_afiliaciones_admin') ||
                                   puede('ver_afiliaciones') ||
                                   puede('gestionar_despachos') ||
                                   puede('crear_venta_operador') ||
                                   puede('registrar_visita_medica');
            
            $mostrar_rrhh = puede('gestionar_nomina');
            
            $mostrar_ajustes = puede('gestionar_roles') || puede('monitorear_sesiones') || puede('gestionar_equipos');
            ?>

            <?php if ($mostrar_principal): ?>
                <div class="sidebar-category">Principal</div>
                <nav class="menu">
                    <a href="/administracion/inicio" class="<?= ($activePage == 'inicio') ? 'active' : '' ?>"><i class="fa-solid fa-tachograph-digital"></i> Dashboard</a>
                </nav>
                <?php if ($mostrar_gestion_datos || $mostrar_operaciones || $mostrar_rrhh || $mostrar_ajustes): ?>
                    <div class="sidebar-divider"></div>
                <?php endif; ?>
            <?php endif; ?>
            
            <?php if ($mostrar_gestion_datos): ?>
                <div class="sidebar-category">Gestión de Datos</div>
                <nav class="menu">
                    <?php if (puede('gestionar_clientes')): ?>
                        <a href="/administracion/clientes" class="<?= ($activePage == 'clientes') ? 'active' : '' ?>"><i class="fa-solid fa-address-book"></i> Clientes</a>
                    <?php endif; ?>
                    <?php if (puede('gestionar_empleados_basico') || puede('gestionar_empleados_avanzado')): ?>
                        <a href="/administracion/empleados" class="<?= ($activePage == 'empleados') ? 'active' : '' ?>"><i class="fa-solid fa-users-cog"></i> Empleados</a>
                    <?php endif; ?>
                </nav>
                <?php if ($mostrar_operaciones || $mostrar_rrhh || $mostrar_ajustes): ?>
                    <div class="sidebar-divider"></div>
                <?php endif; ?>
            <?php endif; ?>

            <?php if ($mostrar_operaciones): ?>
                <div class="sidebar-category">Operaciones</div>
                <nav class="menu">
                    
                    <?php if (puede('ver_agendamiento_global')): ?>
                        <a href="/administracion/agendamiento.php" class="<?= ($activePage == 'agendamiento' || $activePage == 'agendamiento-detalles') ? 'active' : '' ?>">
                            <i class="fa-solid fa-calendar-days"></i> Agendamiento
                        </a>
                    <?php endif; ?>
                    <?php if (puede('ver_dashboard_supervisor')): ?>
                        <a href="/administracion/supervisor" class="<?= ($activePage == 'supervisor') ? 'active' : '' ?>"><i class="fa-solid fa-user-tie"></i>Supervisar Equipo</a>
                    <?php endif; ?>
                    <?php if (puede('gestionar_prospectos_admin')): ?>
                        <a href="/administracion/prospectos-admin" class="<?= ($activePage == 'prospectos-admin') ? 'active' : '' ?>"><i class="fa-solid fa-file-import"></i> Gestión de Prospectos</a>
                    <?php endif; ?>
                    <?php if (puede('gestionar_rutas_admin')): ?>
                        <a href="/administracion/rutas-admin" class="<?= ($activePage == 'rutas-admin' || $activePage == 'ruta-detalle') ? 'active' : '' ?>"><i class="fa-solid fa-map-signs"></i> Administrar Rutas</a>
                    <?php endif; ?>
                    <?php if (puede('ver_prospectos_operador')): ?>
                        <a href="/administracion/prospectos" class="<?= ($activePage == 'prospectos') ? 'active' : '' ?>"><i class="fa-solid fa-phone-volume"></i> Mis Prospectos</a>
                    <?php endif; ?>
                    <?php if (puede('crear_venta_operador')): ?>
                        <a href="/administracion/ventas" class="<?= ($activePage == 'ventas') ? 'active' : '' ?>"><i class="fa-solid fa-cash-register"></i> Registrar Venta</a>
                    <?php endif; ?>
                    <?php if (puede('ver_rutas_coordinador')): ?>
                        <a href="/administracion/mis-rutas" class="<?= ($activePage == 'mis-rutas') ? 'active' : '' ?>"><i class="fa-solid fa-route"></i> Mis Rutas</a>
                    <?php endif; ?>
                    <?php if (puede('ver_inventario')): ?>
                        <a href="/administracion/almacen" class="<?= ($activePage == 'almacen') ? 'active' : '' ?>"><i class="fa-solid fa-warehouse"></i> Almacén</a>
                    <?php endif; ?>
                    <?php if (puede('gestionar_despachos')): ?>
                        <a href="/administracion/despachos" class="<?= ($activePage == 'despachos') ? 'active' : '' ?>"><i class="fa-solid fa-truck-fast"></i> Despachos</a>
                    <?php endif; ?>
                    <?php if (puede('gestionar_afiliaciones')): ?>
                        <a href="/administracion/afiliaciones" class="<?= ($activePage == 'afiliaciones') ? 'active' : '' ?>"><i class="fa-solid fa-handshake"></i> Afiliaciones</a>
                    <?php endif; ?>
                    <?php if (puede('registrar_visita_medica')): ?>
                        <a href="/administracion/visitas" class="<?= ($activePage == 'visitas') ? 'active' : '' ?>"><i class="fa-solid fa-stethoscope"></i> Visitas Médicas</a>
                    <?php endif; ?>
                    <?php if (puede('realizar_cuadre_caja')): ?>
                        <a href="/administracion/cuadre-jornada" class="<?= ($activePage == 'cuadre-jornada') ? 'active' : '' ?>"><i class="fa-solid fa-calculator"></i> Cuadre de Jornada</a>
                    <?php endif; ?>
                    <?php if (puede('ver_reactivacion_admin') || puede('crear_lote_reactivacion')): ?>
                        <a href="/administracion/reactivacion-admin" class="<?= ($activePage == 'reactivacion-admin') ? 'active' : '' ?>"><i class="fa-solid fa-user-check"></i> Reactivación Admin</a>
                    <?php endif; ?>
                    <?php if (puede('ver_reactivacion_supervisor') || puede('distribuir_lote_reactivacion')): ?>
                        <a href="/administracion/reactivacion-supervisor" class="<?= ($activePage == 'reactivacion-supervisor') ? 'active' : '' ?>"><i class="fa-solid fa-users-gear"></i> Reactivación Supervisor</a>
                    <?php endif; ?>
                    <?php if (puede('ver_mis_afiliaciones')): ?>
                        <a href="/administracion/mis-afiliaciones" class="<?= ($activePage == 'mis-afiliaciones') ? 'active' : '' ?>">
                            <i class="fa-solid fa-id-card-clip"></i> Mis Afiliaciones
                        </a>
                    <?php endif; ?>
                    <?php if (puede('gestionar_afiliaciones_admin')): ?>
                        <a href="/administracion/afiliaciones-admin" class="<?= ($activePage == 'afiliaciones-admin') ? 'active' : '' ?>">
                            <i class="fa-solid fa-file-signature"></i>Asignar Numeros Afiliaciones
                        </a>
                    <?php endif; ?>
                </nav>
                <?php if ($mostrar_rrhh || $mostrar_ajustes): ?>
                    <div class="sidebar-divider"></div>
                <?php endif; ?>
            <?php endif; ?>

            <?php if ($mostrar_rrhh): ?>
                <div class="sidebar-category">Recursos Humanos</div>
                <nav class="menu">
                    <?php
                        $isNominaActive = in_array($activePage, ['nominas', 'nomina-crear', 'nomina-detalle', 'nomina-configuracion']);
                    ?>
                    <a href="/administracion/nominas.php" class="<?= (in_array($activePage, ['nominas', 'nomina-crear', 'nomina-detalle'])) ? 'active' : '' ?>">
                        <i class="fa-solid fa-file-invoice-dollar"></i> Gestión de Nóminas
                    </a>
                    <a href="/administracion/nomina-configuracion.php" class="<?= ($activePage == 'nomina-configuracion') ? 'active' : '' ?>">
                        <i class="fa-solid fa-sliders"></i> Configuración de Pagos
                    </a>
                </nav>
                <?php if ($mostrar_ajustes): ?>
                    <div class="sidebar-divider"></div>
                <?php endif; ?>
            <?php endif; ?>
            <?php if ($mostrar_ajustes): ?>
                <div class="sidebar-category">Ajustes del Sistema</div>
                <nav class="menu">
                     <?php if (puede('gestionar_roles')): ?>
                        <a href="/administracion/ajustes/roles" class="<?= ($activePage == 'roles') ? 'active' : '' ?>"><i class="fa-solid fa-shield-halved"></i> Cargos y Permisos</a>
                    <?php endif; ?>
                    <?php if (puede('gestionar_equipos')): ?>
                        <a href="/administracion/ajustes/equipos" class="<?= ($activePage == 'equipos') ? 'active' : '' ?>"><i class="fa-solid fa-sitemap"></i> Gestión de Equipos</a>
                    <?php endif; ?>
                    <?php if (puede('monitorear_sesiones')): ?>
                        <a href="/administracion/ajustes/sesiones" class="<?= ($activePage == 'sesiones') ? 'active' : '' ?>"><i class="fa-solid fa-desktop"></i> Monitor de Actividad</a>
                    <?php endif; ?>
                    <?php if (puede('realizar_cuadre_caja')): ?>
                        <a href="/administracion/ajustes/clave-maestra" class="<?= ($activePage == 'clave-maestra') ? 'active' : '' ?>"><i class="fa-solid fa-key"></i> Clave de Jornada</a>
                    <?php endif; ?>
                </nav>
            <?php endif; ?>
        </div>
    </aside>
    
    <main class="ami-content">