<?php
require_once 'includes/seguridad.php'; 
$page_title = 'Detalle y Seguimiento de Ruta';
include_once 'templates/header.php';

if (!puede('gestionar_rutas_admin')) {
    echo "<main class='ami-content'><div class='info-card'><h1>Acceso Denegado</h1></div></main>";
    include_once 'templates/footer.php';
    exit();
}

$ruta_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$ruta_id) {
    header('Location: rutas-admin.php');
    exit();
}
?>

<style>
    /* --- ESTILOS DEFINITIVOS PARA EL ACORDEÓN Y SU CONTENIDO --- */
    .ami-accordion .accordion-item {
        background-color: var(--card-bg) !important; 
        backdrop-filter: var(--blur-effect);
        -webkit-backdrop-filter: var(--blur-effect);
        border: 1px solid var(--border-color);
        border-radius: 15px !important;
        margin-bottom: 1rem;
        overflow: hidden;
    }
    .ami-accordion .accordion-header .accordion-button {
        background-color: rgba(0,0,0,0.2);
        color: var(--light-text) !important; /* Texto claro para el header */
        font-size: 1.2rem;
        font-weight: bold;
        box-shadow: none !important; /* Quita cualquier sombra de Bootstrap */
        border-radius: 0;
        transition: background-color 0.3s ease;
    }
    .ami-accordion .accordion-header .accordion-button:not(.collapsed) {
        background-color: var(--primary-color);
        color: var(--dark-text) !important; /* Texto oscuro cuando está activo */
    }
    
    /* --- Colores de Estado para las Jornadas --- */
    .ami-accordion .accordion-header .accordion-button.status-completada {
        background-color: #198754; /* Verde Bootstrap */
        color: white !important;
    }
    .ami-accordion .accordion-header .accordion-button.status-en-curso {
        background-color: #0d6efd; /* Azul Bootstrap */
        color: white !important;
    }

    /* --- Corrección para Títulos y Textos Internos --- */
    .ami-accordion .accordion-body h5, 
    .ami-accordion .accordion-body h6,
    .ami-accordion .accordion-body .label {
        color: var(--light-text) !important;
    }
    
    .ami-accordion .accordion-button::after { filter: invert(1) grayscale(100%) brightness(200%); }
    .ami-accordion .accordion-button:not(.collapsed)::after,
    .ami-accordion .accordion-button.status-completada::after,
    .ami-accordion .accordion-button.status-en-curso::after {
        filter: invert(1) brightness(0) contrast(100%);
    }
    .ami-accordion .accordion-body { padding: 1.5rem; }
    
    /* Estilos para las mini-tarjetas del resumen */
    .summary-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(150px, 1fr)); gap: 1rem; text-align: center; }
    .summary-item { background: rgba(0, 0, 0, 0.2); padding: 1rem; border-radius: 10px; border: 1px solid rgba(120, 227, 32, 0.1); }
    .summary-item .value { font-size: 1.5rem; font-weight: bold; color: var(--primary-color); }
    .summary-item .label { font-size: 0.8rem; opacity: 0.8; }
    .summary-item.summary-danger .value { color: #dc3545; } /* Color para el nuevo contador */
    .table-pacientes th, .table-pacientes td { font-size: 0.85rem; vertical-align: middle; }
    .badge-estado { padding: 0.4em 0.7em; border-radius: 10px; font-weight: 500; text-transform: capitalize; min-width: 110px; text-align: center; }
    
    .detalles-pago { font-size: 0.8rem; opacity: 0.9; }
    .detalles-pago a { color: var(--primary-color); text-decoration: none; font-weight: bold; }
    .detalles-pago a:hover { text-decoration: underline; }
</style>

<div class="main-header">
    <div>
        <a href="rutas-admin.php" class="btn btn-outline-light mb-2"><i class="fa-solid fa-arrow-left"></i> Volver al Listado</a>
        <h1 id="main-title">Cargando...</h1>
        <p class="lead" id="coordinador-info"></p>
    </div>
</div>

<div class="accordion ami-accordion" id="accordion-jornadas">
    </div>

<?php include_once 'templates/footer.php'; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const rutaId = <?php echo $ruta_id; ?>;
    let intervalId;

    function getEstadoBadge(estado) {
        const colores = { 'Agendado': 'bg-secondary', 'En consultorio': 'bg-info text-dark', 'Atendido': 'bg-success', 'No asistió': 'bg-warning text-dark', 'Cancelado': 'bg-danger' };
        return `<span class="badge-estado ${colores[estado] || 'bg-light text-dark'}">${estado || 'Indefinido'}</span>`;
    }

    function cargarDetalles() {
        const openAccordionId = document.querySelector('#accordion-jornadas .accordion-collapse.show')?.id;

        fetch(`/api/rutas_ajax.php?action=get_ruta_for_edit&id=${rutaId}`)
        .then(res => res.json())
        .then(data => {
            if (!data.success) {
                Swal.fire('Error', data.message, 'error');
                clearInterval(intervalId);
                return;
            }

            const ruta = data.data;
            document.getElementById('main-title').textContent = `Seguimiento: ${ruta.nombre_ruta}`;
            document.getElementById('coordinador-info').textContent = `Coordinador: ${ruta.coordinador_nombre || 'Sin Asignar'}`;

            const container = document.getElementById('accordion-jornadas');
            container.innerHTML = '';

            if (ruta.jornadas.length === 0) {
                container.innerHTML = '<div class="info-card text-center"><p>Esta ruta aún no tiene jornadas programadas.</p></div>';
                return;
            }

            ruta.jornadas.forEach((jornada) => {
                const totalFacturado = jornada.pacientes.reduce((sum, p) => sum + parseInt(p.total_facturado || 0), 0);
                const atendidos = jornada.pacientes.filter(p => p.estado_cita === 'Atendido').length;
                const cancelados = jornada.pacientes.filter(p => p.estado_cita === 'No asistió' || p.estado_cita === 'Cancelado').length;
                const pendientes = jornada.pacientes.length - atendidos - cancelados;

                let pacientesHtml = '<p class="text-center text-white-50 small mt-3">No hay pacientes asignados a esta jornada.</p>';
                if (jornada.pacientes.length > 0) {
                    pacientesHtml = `
                        <div class="table-responsive">
                            <table class="ami-table table-pacientes mt-3">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Paciente</th>
                                        <th>Estado</th>
                                        <th>Servicios y Productos</th>
                                        <th class="text-end">Total</th>
                                        <th>Notas</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    ${jornada.pacientes.map((p, index) => {
                                        const comprobanteHtml = p.comprobante_pago ? `<a href="/uploads/comprobantes/${p.comprobante_pago}" target="_blank">Ver Comprobante</a>` : 'No aplica';
                                        
                                        const examenesHtml = (p.examenes || []).map(e => `<div><small>${e.nombre_examen} ($${e.precio})</small></div>`).join('');
                                        const medicamentosHtml = (p.medicamentos || []).map(m => `<div><small>${m.nombre_medicamento} ($${m.precio})</small></div>`).join('');

                                        return `
                                            <tr>
                                                <td>${index + 1}</td>
                                                <td>${p.nombre}<br><small>C.I: ${p.cedula} | Tel: ${p.telefono || 'N/A'}</small></td>
                                                <td>${getEstadoBadge(p.estado_cita)}</td>
                                                <td>${examenesHtml}${medicamentosHtml}</td>
                                                <td class="text-end">
                                                    <span class="font-monospace">$${parseInt(p.total_facturado || 0)}</span><br>
                                                    <div class="detalles-pago">
                                                        <span>${p.metodo_pago || 'No definido'}</span> | ${comprobanteHtml}
                                                    </div>
                                                </td>
                                                <td><small>${p.notas_coordinador || ''}</small></td>
                                            </tr>
                                        `;
                                    }).join('')}
                                </tbody>
                            </table>
                        </div>
                    `;
                }

                let statusClass = '';
                if (jornada.estado_jornada === 'Completada') statusClass = 'status-completada';
                else if (jornada.estado_jornada === 'En Curso') statusClass = 'status-en-curso';

                const isShown = `collapse-${jornada.id}` === openAccordionId;

                const canceladosCardHtml = cancelados > 0 ?
                    `<div class="summary-item summary-danger">
                        <div class="value">${cancelados}</div>
                        <div class="label">No Asistió / Cancelado</div>
                    </div>` : '';

                const jornadaHtml = `
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="heading-${jornada.id}">
                            <button class="accordion-button ${isShown ? '' : 'collapsed'} ${statusClass}" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-${jornada.id}">
                                ${jornada.ciudad_nombre} <span class="text-white-50 fs-6 ms-3">- ${new Date(jornada.fecha_jornada + 'T00:00:00').toLocaleDateString('es-ES')}</span>
                            </button>
                        </h2>
                        <div id="collapse-${jornada.id}" class="accordion-collapse collapse ${isShown ? 'show' : ''}" data-bs-parent="#accordion-jornadas">
                            <div class="accordion-body">
                                <h5>Resumen de la Jornada</h5>
                                <div class="summary-grid">
                                    <div class="summary-item"><div class="value">${jornada.pacientes.length}</div><div class="label">Total Pacientes</div></div>
                                    <div class="summary-item"><div class="value">${atendidos}</div><div class="label">Atendidos</div></div>
                                    <div class="summary-item"><div class="value">${pendientes}</div><div class="label">Pendientes</div></div>
                                    <div class="summary-item"><div class="value">$${totalFacturado}</div><div class="label">Total Facturado</div></div>
                                    ${canceladosCardHtml}
                                </div>
                                <hr class="my-4">
                                <h5>Detalle de Pacientes</h5>
                                ${pacientesHtml}
                            </div>
                        </div>
                    </div>
                `;
                container.insertAdjacentHTML('beforeend', jornadaHtml);
            });
        });
    }

    cargarDetalles();
    if (intervalId) clearInterval(intervalId);
    intervalId = setInterval(cargarDetalles, 10000);
});
</script>

<?php include_once 'templates/footer.php'; ?>