<?php
require_once 'includes/seguridad.php'; 

// Permiso para que el supervisor vea sus lotes
if (!puede('ver_reactivacion_supervisor')) {
    header('Location: inicio.php?error=acceso_denegado');
    exit();
}

$page_title = 'Lotes de Reactivación Asignados';
include_once 'templates/header.php';
?>

<div class="main-header">
    <h1><?php echo $page_title; ?></h1>
</div>

<div class="info-card">
    <table class="ami-table">
        <thead>
            <tr>
                <th>Nombre del Lote</th>
                <th>Creado por</th>
                <th>Fecha de Creación</th>
                <th>Total de Clientes</th>
                <th>Clientes Asignados</th>
                <th>Estado</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody id="tabla-lotes-supervisor">
            </tbody>
    </table>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const tbody = document.getElementById('tabla-lotes-supervisor');

    function cargarLotes() {
        tbody.innerHTML = '<tr><td colspan="7" class="text-center">Cargando lotes...</td></tr>';

        fetch('/api/reactivacion_ajax.php?action=get_lotes_supervisor')
        .then(res => res.json())
        .then(data => {
            if (!data.success) {
                tbody.innerHTML = `<tr><td colspan="7" class="text-center text-danger">${data.message}</td></tr>`;
                return;
            }
            renderizarLotes(data.data);
        })
        .catch(error => {
            console.error('Error:', error);
            tbody.innerHTML = `<tr><td colspan="7" class="text-center text-danger">Error de conexión al cargar los lotes.</td></tr>`;
        });
    }

    function renderizarLotes(lotes) {
        if (lotes.length === 0) {
            tbody.innerHTML = '<tr><td colspan="7" class="text-center">No tienes lotes de reactivación asignados.</td></tr>';
            return;
        }

        let filasHtml = '';
        lotes.forEach(lote => {
            let estadoClass = '';
            switch(lote.estado) {
                case 'Pendiente': estadoClass = 'bg-warning text-dark'; break;
                case 'En Progreso': estadoClass = 'bg-info text-dark'; break;
                case 'Completado': estadoClass = 'bg-success'; break;
            }

            filasHtml += `
                <tr>
                    <td><strong>${lote.nombre_lote}</strong></td>
                    <td>${lote.admin_nombre}</td>
                    <td>${new Date(lote.fecha_creacion).toLocaleDateString()}</td>
                    <td>${lote.total_clientes}</td>
                    <td>${lote.clientes_asignados}</td>
                    <td><span class="badge ${estadoClass}">${lote.estado}</span></td>
                    <td>
                        <a href="reactivacion-detalle-lote.php?id=${lote.id}" class="btn btn-primary btn-sm">
                            <i class="fa-solid fa-users-viewfinder me-2"></i>Gestionar Lote
                        </a>
                    </td>
                </tr>
            `;
        });
        tbody.innerHTML = filasHtml;
    }

    cargarLotes();
});
</script>

<?php include_once 'templates/footer.php'; ?>