<?php
require_once 'includes/seguridad.php'; 
$page_title = 'Dashboard de Prospectos';
include_once 'templates/header.php';

if (!puede('gestionar_prospectos_admin')) {
    echo "<main class='ami-content'><div class='info-card' style='text-align:center;'><h1><i class='fa-solid fa-ban' style='color: #dc3545;'></i> Acceso Denegado</h1><p>No tienes permiso para ver esta página.</p></div></main>";
    include_once 'templates/footer.php';
    exit();
}
?>

<style>
.dashboard-stats { display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem; margin-bottom: 2rem; }
.stat-card { background: var(--card-bg); padding: 1.5rem; border-radius: 12px; text-align: center; }
.stat-card .stat-value { font-size: 2.5rem; font-weight: 700; color: var(--primary-color); }
.stat-card .stat-label { font-size: 1rem; opacity: 0.8; }
.table-actions { display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem; }
.search-input { max-width: 300px; }
.badge-asignado { background-color: rgba(13, 110, 253, 0.2); color: #0d6efd; border: 1px solid #0d6efd;}
.badge-sin-asignar { background-color: rgba(108, 117, 125, 0.2); color: #6c757d; border: 1px solid #6c757d;}
.progress { height: 10px; background-color: rgba(0,0,0,0.3); }
.progress-bar { background-color: var(--primary-color); }
</style>

<div class="main-header">
    <h1><?php echo $page_title; ?></h1>
</div>

<div class="dashboard-stats">
    <div class="stat-card">
        <div id="piscina-count" class="stat-value">...</div>
        <div class="stat-label">Prospectos en Piscina (Sin Asignar)</div>
    </div>
    <div class="stat-card" style="display: flex; flex-direction: column; justify-content: center; gap: 1rem;">
        <button class="btn btn-primary btn-lg w-100" data-bs-toggle="modal" data-bs-target="#modalImportarPiscina">
            <i class="fa-solid fa-file-csv"></i> Importar a la Piscina
        </button>
        <button class="btn btn-success btn-lg w-100" data-bs-toggle="modal" data-bs-target="#modalCrearLote">
            <i class="fa-solid fa-plus"></i> Crear Nuevo Lote de Trabajo
        </button>
    </div>
</div>

<div class="info-card">
    <div class="table-actions">
        <h4>Historial de Lotes Creados</h4>
        <input type="text" id="filtroLotes" class="form-control form-control-dark search-input" placeholder="Buscar por nombre o operador...">
    </div>
    <table class="ami-table">
        <thead>
            <tr>
                <th>Nombre del Lote</th>
                <th>Operador Asignado</th>
                <th>Progreso</th>
                <th style="text-align: center;">Prospectos</th>
                <th>Fecha Asignación</th>
                <th style="text-align: center;">Acciones</th>
            </tr>
        </thead>
        <tbody id="tablaLotes">
            <tr><td colspan="6" class="text-center">Cargando...</td></tr>
        </tbody>
    </table>
</div>

<div class="modal fade" id="modalImportarPiscina" tabindex="-1">
    <div class="modal-dialog ami-modal-dialog"> <div class="modal-content ami-modal-content"> <div class="ami-modal-header">
                <h5 class="ami-modal-title">Importar Prospectos a la Piscina General</h5>
                <button type="button" class="ami-btn-close" data-bs-dismiss="modal">&times;</button>
            </div>
            <div class="ami-modal-body">
                <form id="formImportarPiscina" enctype="multipart/form-data">
                    <input type="hidden" name="action" value="importar_a_piscina">
                    <div class="ami-form-group">
                        <label class="ami-form-label">Archivo .csv</label>
                        <input type="file" class="ami-form-control" name="archivo_csv" accept=".csv" required>
                    </div>
                    <div class="form-text mt-2"><a href="/plantilla_prospectos.csv" download>Descargar plantilla de ejemplo</a></div>
                    <hr class="my-4" style="border-color: var(--border-color);">
                    <button type="submit" class="ami-btn ami-btn-primary w-100">Cargar Prospectos</button>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modalCrearLote" tabindex="-1">
    <div class="modal-dialog ami-modal-dialog"> <div class="modal-content ami-modal-content"> <div class="ami-modal-header">
                <h5 class="ami-modal-title">Crear y Asignar Lote de Trabajo</h5>
                <button type="button" class="ami-btn-close" data-bs-dismiss="modal">&times;</button>
            </div>
            <div class="ami-modal-body">
                <form id="formCrearLote">
                    <input type="hidden" name="action" value="crear_lote_y_asignar">
                    <div class="ami-form-group mb-3">
                        <label class="ami-form-label">Nombre del Lote</label>
                        <input type="text" class="ami-form-control" name="nombre_lote" placeholder="Ej: Campaña de Seguros - Agosto" required>
                    </div>
                    <div class="ami-form-group mb-3">
                        <label class="ami-form-label">Asignar a Operador</label>
                        <select name="operador_id" id="selectOperadorAsignar" class="ami-form-control" required></select>
                    </div>
                    <div class="ami-form-group">
                        <label class="ami-form-label">Cantidad de Prospectos a Asignar</label>
                        <input type="number" class="ami-form-control" name="cantidad" placeholder="Ej: 50" min="1" required>
                        <small class="form-text text-white-50">Se tomarán aleatoriamente de la piscina.</small>
                    </div>
                    <hr class="my-4" style="border-color: var(--border-color);">
                    <button type="submit" class="ami-btn ami-btn-primary w-100">Crear y Asignar</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

function cargarDashboard() {
    fetch(`/api/prospectos_ajax.php?action=cargar_dashboard_admin`)
        .then(res => res.json())
        .then(data => {
            if (!data.success) {
                Swal.fire('Error', data.message, 'error');
                return;
            }
            document.getElementById('piscina-count').textContent = data.data.piscina_count;
            const selectOperador = document.getElementById('selectOperadorAsignar');
            selectOperador.innerHTML = '<option value="" disabled selected>Seleccione un operador</option>';
            data.data.operadores.forEach(op => {
                selectOperador.innerHTML += `<option value="${op.id}">${op.nombre}</option>`;
            });
            const tablaLotesBody = document.getElementById('tablaLotes');
            tablaLotesBody.innerHTML = '';
            if (data.data.lotes.length > 0) {
                data.data.lotes.forEach(lote => {
                    const fecha = lote.fecha_asignacion ? new Date(lote.fecha_asignacion).toLocaleDateString() : 'N/A';
                    tablaLotesBody.innerHTML += `
                        <tr>
                            <td><strong>${lote.nombre}</strong></td>
                            <td>${lote.operador_nombre || '<span class="badge badge-sin-asignar">No asignado</span>'}</td>
                            <td>
                                <div class="progress"><div class="progress-bar" style="width: ${lote.progreso}%;" role="progressbar"></div></div>
                                <small>${lote.progreso}%</small>
                            </td>
                            <td class="text-center">${lote.gestionados} / ${lote.total_prospectos}</td>
                            <td>${fecha}</td>
                            <td class="text-center">
                                <button class="btn-action" title="Ver Detalles" onclick="verDetallesLote(${lote.id})"><i class="fa-solid fa-eye"></i></button>
                            </td>
                        </tr>
                    `;
                });
            } else {
                tablaLotesBody.innerHTML = '<tr><td colspan="6" class="text-center">No se han creado lotes todavía.</td></tr>';
            }
        });
}

function verDetallesLote(id) {
    window.location.href = `lote-detalle?id=${id}`;
}

document.getElementById('formImportarPiscina').addEventListener('submit', function(e){
    e.preventDefault();
    const formData = new FormData(this);
    formData.append('csrf_token', csrfToken);
    
    Swal.fire({ title: 'Procesando...', text: 'Importando, por favor espera.', allowOutsideClick: false, didOpen: () => Swal.showLoading() });
    bootstrap.Modal.getInstance(document.getElementById('modalImportarPiscina')).hide();

    fetch('/api/prospectos_ajax.php', { method: 'POST', body: formData })
    .then(response => response.json())
    .then(data => {
        if(data.success) {
            Swal.fire('¡Éxito!', data.message, 'success').then(() => cargarDashboard());
        } else {
            Swal.fire('Error', data.message, 'error');
        }
    });
});

document.getElementById('formCrearLote').addEventListener('submit', function(e) {
    e.preventDefault();
    const formData = new FormData(this);
    formData.append('csrf_token', csrfToken);
    
    Swal.fire({ title: 'Creando Lote...', allowOutsideClick: false, didOpen: () => Swal.showLoading() });
    bootstrap.Modal.getInstance(document.getElementById('modalCrearLote')).hide();
    
    fetch('/api/prospectos_ajax.php', { method: 'POST', body: formData })
    .then(res => res.json())
    .then(data => {
        if(data.success) {
            Swal.fire('¡Éxito!', data.message, 'success').then(() => cargarDashboard());
        } else { 
            Swal.fire('Error', data.message, 'error');
            bootstrap.Modal.getInstance(document.getElementById('modalCrearLote')).show();
        }
    });
});

document.addEventListener('DOMContentLoaded', cargarDashboard);

document.getElementById('filtroLotes').addEventListener('keyup', function() {
    const filtro = this.value.toLowerCase();
    const filas = document.getElementById('tablaLotes').getElementsByTagName('tr');
    for (let fila of filas) {
        fila.style.display = fila.textContent.toLowerCase().includes(filtro) ? '' : 'none';
    }
});
</script>

<?php include_once 'templates/footer.php'; ?>