<?php
require_once 'includes/seguridad.php';
if (!puede('gestionar_nomina')) { header('Location: inicio.php?error=acceso_denegado'); exit(); }
$page_title = 'Configuración de Nómina';
include_once 'templates/header.php';
?>

<div class="main-header">
    <h1><?php echo htmlspecialchars($page_title); ?></h1>
</div>

<div class="info-card">
    <div class="alert alert-info">
        <p class="mb-0"><i class="fa-solid fa-circle-info me-2"></i>Aquí puedes establecer los montos mensuales fijos en dólares ($) para cada empleado. Estos valores se cargarán automáticamente al crear una nueva nómina.</p>
    </div>
    
    <div class="table-responsive mt-3">
        <table class="ami-table" id="tabla-config-nomina">
            <thead>
                <tr>
                    <th>Empleado</th>
                    <th>Cesta Ticket ($)</th>
                    <th>Comp. Cesta Ticket ($)</th>
                    <th>Bono Transporte ($)</th>
                    <th>Comp. Productividad ($)</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody id="body-tabla-config">
                </tbody>
        </table>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const csrfToken = '<?php echo $_SESSION['csrf_token']; ?>';
    const tbody = document.getElementById('body-tabla-config');

    const cargarConfiguraciones = () => {
        tbody.innerHTML = `<tr><td colspan="6" class="text-center">Cargando...</td></tr>`;
        fetch('../api/nomina_configuracion_ajax.php?action=cargar_configuraciones')
            .then(res => res.json())
            .then(response => {
                if (response.success) {
                    renderizarTabla(response.data);
                } else {
                    tbody.innerHTML = `<tr><td colspan="6" class="text-center text-danger">${response.message}</td></tr>`;
                }
            });
    };

    const renderizarTabla = (empleados) => {
        tbody.innerHTML = '';
        empleados.forEach(emp => {
            const fila = document.createElement('tr');
            fila.dataset.usuarioId = emp.usuario_id;
            fila.innerHTML = `
                <td>
                    <strong>${emp.nombre}</strong><br>
                    <small class="text-muted">C.I: ${emp.cedula}</small>
                </td>
                <td><input type="number" step="0.01" class="form-control" data-field="cesta_ticket" value="${parseFloat(emp.cesta_ticket || 40.00).toFixed(2)}"></td>
                <td><input type="number" step="0.01" class="form-control" data-field="complemento_cesta_ticket" value="${parseFloat(emp.complemento_cesta_ticket || 30.00).toFixed(2)}"></td>
                <td><input type="number" step="0.01" class="form-control" data-field="bono_transporte" value="${parseFloat(emp.bono_transporte || 40.00).toFixed(2)}"></td>
                <td><input type="number" step="0.01" class="form-control" data-field="complemento_productividad" value="${parseFloat(emp.complemento_productividad || 0.00).toFixed(2)}"></td>
                <td>
                    <button class="btn btn-primary btn-sm btn-save-config">
                        <i class="fa-solid fa-save"></i>
                    </button>
                </td>
            `;
            tbody.appendChild(fila);
        });
    };

    tbody.addEventListener('click', function(e) {
        if (e.target.classList.contains('btn-save-config') || e.target.closest('.btn-save-config')) {
            const btn = e.target.closest('.btn-save-config');
            const fila = btn.closest('tr');
            const usuarioId = fila.dataset.usuarioId;
            
            const formData = new FormData();
            formData.append('action', 'guardar_configuracion');
            formData.append('csrf_token', csrfToken);
            formData.append('usuario_id', usuarioId);
            formData.append('cesta_ticket', fila.querySelector('[data-field="cesta_ticket"]').value);
            formData.append('complemento_cesta_ticket', fila.querySelector('[data-field="complemento_cesta_ticket"]').value);
            formData.append('bono_transporte', fila.querySelector('[data-field="bono_transporte"]').value);
            formData.append('complemento_productividad', fila.querySelector('[data-field="complemento_productividad"]').value);

            // Feedback visual para el usuario
            const originalIcon = btn.innerHTML;
            btn.innerHTML = `<span class="spinner-border spinner-border-sm"></span>`;
            btn.disabled = true;

            fetch('../api/nomina_configuracion_ajax.php', { method: 'POST', body: formData })
                .then(res => res.json())
                .then(response => {
                    if (response.success) {
                        // Cambia el icono a un check verde por un momento
                        btn.innerHTML = `<i class="fa-solid fa-check"></i>`;
                        btn.classList.replace('btn-primary', 'btn-success');
                        setTimeout(() => {
                            btn.innerHTML = originalIcon;
                            btn.classList.replace('btn-success', 'btn-primary');
                            btn.disabled = false;
                        }, 1500);
                    } else {
                        Swal.fire('Error', response.message, 'error');
                        btn.innerHTML = originalIcon;
                        btn.disabled = false;
                    }
                });
        }
    });

    cargarConfiguraciones();
});
</script>

<?php include_once 'templates/footer.php'; ?>