<?php
require_once 'includes/seguridad.php';
$page_title = 'Mis Afiliaciones';
include_once 'templates/header.php';

if (!puede('ver_mis_afiliaciones')) {
    echo "<main class='ami-content'><div class='info-card'><h1>Acceso Denegado</h1></div></main>";
    include_once 'templates/footer.php';
    exit();
}
?>
<style>
    .nav-tabs .nav-link { color: var(--light-text); }
    .nav-tabs .nav-link.active { color: var(--dark-text); background-color: var(--primary-color); border-color: var(--primary-color); }
    .stat-card { background: var(--card-bg); padding: 0.75rem; border-radius: 12px; text-align: center; height: 60px; display: flex; flex-direction: column; justify-content: center; }
    .stat-card .stat-value { font-size: 1.8rem; font-weight: 700; color: var(--primary-color); }
    .stat-card .stat-label { font-size: 0.8rem; opacity: 0.8; }
    .info-card h4 { color: var(--primary-color); margin-bottom: 1rem; }
    .profile-pic-table { width: 40px; height: 40px; border-radius: 50%; object-fit: cover; }
    .status-dot { height: 10px; width: 10px; border-radius: 50%; display: inline-block; margin-right: 8px; }
    .status-dot.online { background-color: #28a745; box-shadow: 0 0 8px #28a745; animation: pulse 2s infinite; }
    .status-dot.offline { background-color: #6c757d; }
    .progress { height: 8px; background-color: rgba(255,255,255,0.1); border-radius: 5px; }
    .progress-bar { border-radius: 5px; background-color: var(--primary-color); }
    @keyframes pulse { 0% { box-shadow: 0 0 0 0 rgba(40, 167, 69, 0.7); } 70% { box-shadow: 0 0 0 10px rgba(40, 167, 69, 0); } 100% { box-shadow: 0 0 0 0 rgba(40, 167, 69, 0); } }
    .table-responsive { margin-top: 1rem; }
    .btn-add-new { font-size: 0.9rem; padding: 0.5rem 1rem; }
    .header-actions { display: flex; align-items: center; gap: 1rem; }
    .stat-card-mini { background: var(--card-bg); padding: 0.5rem 1rem; border-radius: 12px; text-align: center; border: 1px solid var(--border-color); }
    .stat-card-mini .stat-value { font-size: 1.8rem; font-weight: 700; color: var(--primary-color); }
    .stat-card-mini .stat-label { font-size: 0.75rem; opacity: 0.8; text-transform: uppercase; margin-top: -5px; display: block; }
    .ami-table tbody tr { cursor: pointer; transition: background-color 0.2s ease; }
    .ami-table tbody tr:hover { background-color: rgba(120, 227, 32, 0.1); }
    #historialObservaciones { max-height: 200px; overflow-y: auto; background: rgba(0,0,0,0.2); padding: 10px; border-radius: 5px; white-space: pre-wrap; font-size: 0.9em; border: 1px solid var(--border-color); margin-bottom: 1rem; }
    .telefono-clickable { cursor: pointer; text-decoration: underline; text-decoration-color: var(--primary-color); text-decoration-thickness: 1px; transition: color 0.2s ease; }
    .telefono-clickable:hover { color: var(--primary-color); }
    .info-card { margin-bottom: 2rem; }
    .toolbar { margin-bottom: 1rem; }
</style>

<div class="main-header">
    <h1><?php echo $page_title; ?></h1>
    <div class="header-actions">
        <div class="stat-card-mini">
            <div id="pendientes-count" class="stat-value">0</div>
            <div class="stat-label">Pendientes</div>
        </div>
    </div>
</div>

<div class="info-card">
    <ul class="nav nav-tabs" id="afiliacionesTab" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="pap-tab" data-bs-toggle="tab" data-bs-target="#pap-panel" type="button" role="tab">
                <i class="fa-solid fa-user-plus me-2"></i> PaP (Puerta a Puerta)
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="otros-tab" data-bs-toggle="tab" data-bs-target="#otros-panel" type="button" role="tab">
                <i class="fa-solid fa-users me-2"></i> Asignados
            </button>
        </li>
    </ul>

    <div class="tab-content pt-4">
        <div class="tab-pane fade show active" id="pap-panel" role="tabpanel">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h4><i class="fa-solid fa-user-plus text-success me-2"></i> Contactos PaP</h4>
                <span class="stat-card" style="width: 100px; height: 60px; padding: 0.5rem;">
                    <div id="pap-count" class="stat-value">0</div>
                    <div class="stat-label">Total</div>
                </span>
            </div>
            <div class="toolbar mb-3">
                <input type="text" id="searchInput" class="form-control form-control-dark" placeholder="Buscar por nombre, teléfono o zona...">
            </div>
            <button class="btn btn-success btn-sm mb-3" id="btnAbrirModalManual"><i class="fa-solid fa-plus"></i> Agregar PaP</button>
            <div class="table-responsive">
                <table class="ami-table">
                    <thead>
                        <tr>
                            <th style="width: 50px;">#</th>
                            <th>Nombre</th>
                            <th>Teléfono</th>
                            <th>Zona</th>
                            <th>Estado</th>
                            <th>Último Contacto</th>
                            <th>Fecha Asignación</th>
                        </tr>
                    </thead>
                    <tbody id="tabla-pap"></tbody>
                </table>
            </div>
        </div>

        <div class="tab-pane fade" id="otros-panel" role="tabpanel">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h4><i class="fa-solid fa-users text-primary me-2"></i> Otros Orígenes</h4>
                <span class="stat-card" style="width: 100px; height: 60px; padding: 0.5rem;">
                    <div id="otros-count" class="stat-value">0</div>
                    <div class="stat-label">Total</div>
                </span>
            </div>
            <div class="toolbar mb-3">
                <input type="text" id="searchInputOtros" class="form-control form-control-dark" placeholder="Buscar por nombre, teléfono o zona...">
            </div>
            <div class="table-responsive">
                <table class="ami-table">
                    <thead>
                        <tr>
                            <th style="width: 50px;">#</th>
                            <th>Nombre</th>
                            <th>Teléfono</th>
                            <th>Zona</th>
                            <th>Estado</th>
                            <th>Último Contacto</th>
                            <th>Fecha Asignación</th>
                        </tr>
                    </thead>
                    <tbody id="tabla-otros"></tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="modal fade ami-modal-theme" id="modalGestionar" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header"><h5 class="modal-title">Gestionar: <span id="modalNombreCliente" class="text-primary"></span></h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
            <div class="modal-body">
                <form id="formGestionar">
                    <input type="hidden" name="gestion_id" id="gestion_id">
                    
                    <div id="nombre-container" class="mb-3" style="display: none;"></div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3"><label class="ami-form-label">Estado de la Gestión</label><select name="estado" id="gestionEstado" class="form-select"></select></div>
                        <div class="col-md-6 mb-3"><label class="ami-form-label">Zona (Ubicación)</label><input type="text" name="zona" id="gestionZona" class="form-control"></div>
                    </div>
                    <div class="mb-3"><label class="ami-form-label">Historial de Observaciones</label><div id="historialObservaciones"></div></div>
                    <div><label class="ami-form-label">Nueva Observación</label><textarea name="observaciones" class="form-control" rows="4" placeholder="Detalles de la llamada..."></textarea></div>
                </form>
            </div>
            <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button><button type="button" class="btn btn-primary" id="btnGuardarGestion">Guardar Cambios</button></div>
        </div>
    </div>
</div>

<div class="modal fade ami-modal-theme" id="modalAgregarManual" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header"><h5 class="modal-title">Agregar Contacto PaP</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
            <div class="modal-body">
                <form id="formAgregarManual">
                    <div class="ami-form-group mb-3">
                        <label class="ami-form-label">Nombre Completo</label>
                        <input type="text" name="nombre" class="form-control" placeholder="Dejar en blanco para 'Sin Nombre'">
                    </div>
                    <div class="ami-form-group mb-3">
                        <label class="ami-form-label">Teléfono (Solo números)</label>
                        <input type="text" name="telefono" class="form-control" required inputmode="numeric">
                    </div>
                    <div class="ami-form-group">
                        <label class="ami-form-label">Campaña</label>
                        <input type="text" name="campana" class="form-control">
                    </div>
                </form>
            </div>
            <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button><button type="button" class="btn btn-primary" id="btnConfirmarAgregarManual">Agregar a mi lista</button></div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const csrfToken = '<?php echo $_SESSION['csrf_token']; ?>';
    const tablaPap = document.getElementById('tabla-pap');
    const tablaOtros = document.getElementById('tabla-otros');
    const papCountEl = document.getElementById('pap-count');
    const otrosCountEl = document.getElementById('otros-count');
    const pendientesCountEl = document.getElementById('pendientes-count');
    const searchInput = document.getElementById('searchInput');
    const searchInputOtros = document.getElementById('searchInputOtros');
    const modalGestion = new bootstrap.Modal(document.getElementById('modalGestionar'));
    const modalManual = new bootstrap.Modal(document.getElementById('modalAgregarManual'));
    let afiliacionesData = { pap: [], otros: [] };
    let searchTimeout;

    const estados = ['Pendiente', 'No contesta', 'Llamar luego', 'Whatsapp', 'Por confirmar', 'Afiliado', 'Refiere', 'No tiene dinero', 'No le interesa', 'Está en otro lugar', 'Seguimiento', 'Colgo', 'no coge la llamada', 'apagado', 'suspendido', 'Equivocado'];
    const selectEstado = document.getElementById('gestionEstado');
    selectEstado.innerHTML = estados.map(e => `<option value="${e}">${e}</option>`).join('');

    function cargarAfiliaciones() {
        const activeTab = document.querySelector('#afiliacionesTab .nav-link.active').id;
        const currentSearchInput = activeTab === 'pap-tab' ? searchInput : searchInputOtros;
        const searchTerm = currentSearchInput.value;

        // Mostrar 'Cargando...' en ambas tablas para evitar confusiones
        tablaPap.innerHTML = `<tr><td colspan="7" class="text-center">Cargando...</td></tr>`;
        tablaOtros.innerHTML = `<tr><td colspan="7" class="text-center">Cargando...</td></tr>`;

        fetch(`/api/mis_afiliaciones_ajax.php?action=cargar_mis_afiliaciones&search=${encodeURIComponent(searchTerm)}`)
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    afiliacionesData.pap = data.data_pap || [];
                    afiliacionesData.otros = data.data_otros || [];
                    papCountEl.textContent = data.count_pap || 0;
                    otrosCountEl.textContent = data.count_otros || 0;
                    pendientesCountEl.textContent = data.pendientes_count || 0;
                    renderizarTablas();
                } else {
                    tablaPap.innerHTML = `<tr><td colspan="7" class="text-center text-danger">${data.message}</td></tr>`;
                    tablaOtros.innerHTML = `<tr><td colspan="7" class="text-center text-danger">${data.message}</td></tr>`;
                }
            })
            .catch(() => {
                tablaPap.innerHTML = `<tr><td colspan="7" class="text-center text-danger">Error de red.</td></tr>`;
                tablaOtros.innerHTML = `<tr><td colspan="7" class="text-center text-danger">Error de red.</td></tr>`;
            });
    }
    
    function renderizarTablas() {
        const renderSingleTable = (tbody, data) => {
            if (data.length === 0) {
                tbody.innerHTML = '<tr><td colspan="7" class="text-center">No hay registros para mostrar.</td></tr>';
            } else {
                tbody.innerHTML = data.map((a, index) => {
                    const fechaContacto = a.fecha_ultimo_contacto ? new Date(a.fecha_ultimo_contacto).toLocaleString('es-ES', { day: 'numeric', month: 'short', hour: '2-digit', minute: '2-digit' }) : 'Nunca';
                    const fechaAsignacion = a.fecha_asignacion ? new Date(a.fecha_asignacion).toLocaleDateString('es-ES') : 'N/A';
                    const telefonoHTML = a.telefono ? `<span class="telefono-clickable" onclick="event.stopPropagation(); confirmarWhatsApp('${a.telefono}')">${a.telefono}</span>` : 'N/A';
                    const numeroFila = data.length - index;
                    return `
                        <tr onclick='abrirModalGestion(${JSON.stringify(a)})'>
                            <td><strong>${numeroFila}</strong></td>
                            <td><strong>${a.nombre}</strong><br><small class="text-white-50">${a.campana || 'Sin campaña'}</small></td>
                            <td>${telefonoHTML}</td>
                            <td>${a.zona || 'N/A'}</td>
                            <td><span class="badge bg-info text-dark">${a.estado}</span></td>
                            <td>${fechaContacto}</td>
                            <td>${fechaAsignacion}</td>
                        </tr>`;
                }).join('');
            }
        };
        renderSingleTable(tablaPap, afiliacionesData.pap);
        renderSingleTable(tablaOtros, afiliacionesData.otros);
    }

    // --- MODIFICACIÓN: Lógica para mostrar/ocultar el campo de nombre ---
    window.abrirModalGestion = function(gestion) {
        const nombreContainer = document.getElementById('nombre-container');
        
        document.getElementById('modalNombreCliente').textContent = gestion.nombre;
        document.getElementById('gestion_id').value = gestion.id;
        document.getElementById('gestionEstado').value = gestion.estado;
        document.getElementById('gestionZona').value = gestion.zona || '';
        document.getElementById('historialObservaciones').textContent = gestion.observaciones || 'Sin observaciones previas.';
        document.querySelector('#formGestionar textarea[name="observaciones"]').value = '';
        
        if (gestion.nombre === 'Sin Nombre') {
            nombreContainer.innerHTML = `
                <label class="ami-form-label">Agregar Nombre del Cliente</label>
                <input type="text" name="nombre" class="form-control" placeholder="Ingrese el nombre aquí...">
            `;
            nombreContainer.style.display = 'block';
        } else {
            // Se inserta un input oculto para no perder el nombre actual al guardar
            nombreContainer.innerHTML = `<input type="hidden" name="nombre" value="${gestion.nombre}">`;
            nombreContainer.style.display = 'none';
        }
        
        modalGestion.show();
    };
    
    window.confirmarWhatsApp = (telefono) => {
        if (confirm(`¿Deseas abrir WhatsApp con ${telefono}?`)) {
            window.open(`https://wa.me/${telefono.replace(/\D/g, '')}`, '_blank');
        }
    };
    
    document.getElementById('btnGuardarGestion').addEventListener('click', function() {
        const form = document.getElementById('formGestionar');
        const formData = new FormData(form);
        formData.append('action', 'actualizar_gestion');
        formData.append('csrf_token', csrfToken);
        
        fetch('/api/mis_afiliaciones_ajax.php', { method: 'POST', body: formData })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                modalGestion.hide();
                Swal.fire({toast: true, position: 'top-end', icon: 'success', title: data.message, showConfirmButton: false, timer: 2000});
                cargarAfiliaciones();
            } else {
                Swal.fire('Error', data.message, 'error');
            }
        });
    });
    
    document.getElementById('btnAbrirModalManual').addEventListener('click', () => {
        document.getElementById('formAgregarManual').reset();
        modalManual.show();
    });

    // --- MODIFICACIÓN: Validación de teléfono y lógica de envío ---
    document.getElementById('btnConfirmarAgregarManual').addEventListener('click', function() {
        const form = document.getElementById('formAgregarManual');
        const telefonoInput = form.querySelector('input[name="telefono"]');

        // Se valida que el teléfono no esté vacío. El nombre es opcional.
        if (!telefonoInput.value.trim()) {
            Swal.fire('Atención', 'El campo teléfono es obligatorio.', 'warning');
            return;
        }

        const formData = new FormData(form);
        formData.append('action', 'agregar_contacto_operador');
        formData.append('csrf_token', csrfToken);
        
        modalManual.hide();
        Swal.fire({ title: 'Guardando...', allowOutsideClick: false, didOpen: () => Swal.showLoading() });

        fetch('/api/mis_afiliaciones_ajax.php', { method: 'POST', body: formData })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                Swal.fire('¡Éxito!', data.message, 'success').then(cargarAfiliaciones);
            } else {
                Swal.fire('Error', data.message, 'error');
            }
        });
    });

    // --- NUEVO: Listener para forzar solo números en el campo de teléfono ---
    const telefonoInputManual = document.querySelector('#formAgregarManual input[name="telefono"]');
    telefonoInputManual.addEventListener('input', function(e) {
        e.target.value = e.target.value.replace(/[^0-9]/g, '');
    });
    
    function setupSearch(inputElement) {
        inputElement.addEventListener('input', () => {
            clearTimeout(searchTimeout);
            searchTimeout = setTimeout(cargarAfiliaciones, 500);
        });
    }

    setupSearch(searchInput);
    setupSearch(searchInputOtros);

    const tabs = document.querySelectorAll('#afiliacionesTab .nav-link');
    tabs.forEach(tab => {
        tab.addEventListener('shown.bs.tab', cargarAfiliaciones);
    });
    
    cargarAfiliaciones();
});
</script>

<?php include_once 'templates/footer.php'; ?>