<?php
require_once 'includes/seguridad.php';
$page_title = 'Memorandos y Mensajes';
include_once 'templates/header.php';
?>

<style>
    .mensajeria-container {
        display: grid;
        grid-template-columns: 380px 1fr;
        gap: 1.5rem;
        height: calc(100vh - 200px); /* Altura fija para el contenedor principal */
    }

    .lista-conversaciones {
        background: rgba(0, 0, 0, 0.15);
        border-radius: 12px;
        padding: 0.5rem;
        overflow-y: auto; /* Scroll vertical si el contenido excede */
        height: 100%;     /* Ocupa toda la altura de la celda del grid */
    }

    .chat-container {
        background: var(--card-bg);
        border-radius: 12px;
        display: flex;
        flex-direction: column;
        height: 100%; /* Ocupa toda la altura de la celda del grid */
    }

    .conversacion-item {
        padding: 1rem;
        border-radius: 8px;
        margin-bottom: 0.5rem;
        cursor: pointer;
        transition: background-color 0.2s ease, border-left-color 0.3s ease;
        border-left: 4px solid transparent;
        background-color: rgba(255, 255, 255, 0.03);
        position: relative; /* Para posicionar el punto de notificación */
    }
    
    .conversacion-item:hover { background-color: rgba(120, 227, 32, 0.1); }
    .conversacion-item.active { background-color: rgba(120, 227, 32, 0.2); border-left-color: var(--primary-color); }
    
    /* NUEVO: Estilo para el punto de notificación */
    .notificacion-punto {
        position: absolute;
        top: 18px;
        right: 18px;
        width: 10px;
        height: 10px;
        background-color: var(--danger-color);
        border-radius: 50%;
        border: 1px solid var(--card-bg);
    }

    .chat-header { padding: 1rem; border-bottom: 1px solid var(--border-color); }
    
    .chat-body {
        flex: 1; /* Ocupa el espacio restante */
        padding: 1.5rem;
        overflow-y: auto; /* El scroll ahora funciona dentro de una altura fija */
        background-color: rgba(0, 0, 0, 0.2);
    }

    .chat-footer { padding: 1rem; border-top: 1px solid var(--border-color); }

    .mensaje {
        margin-bottom: 1rem;
        max-width: 70%;
        display: flex;
        align-items: flex-end;
        gap: 10px;
        animation: fadeIn 0.5s ease-out;
    }
    @keyframes fadeIn { from { opacity: 0; transform: translateY(10px); } to { opacity: 1; transform: translateY(0); } }
    
    .mensaje-burbuja { padding: 0.75rem 1rem; border-radius: 18px; word-wrap: break-word; }
    .mensaje.propio { align-self: flex-end; flex-direction: row-reverse; }
    .mensaje.propio .mensaje-burbuja { background-color: var(--primary-color); color: var(--dark-text); border-bottom-right-radius: 4px; }
    .mensaje.ajeno .mensaje-burbuja { background-color: var(--sidebar-bg); border-bottom-left-radius: 4px; }
    
    .mensaje-meta { font-size: 0.75rem; opacity: 0.7; }
    .perfil-pic-chat { width: 40px; height: 40px; border-radius: 50%; object-fit: cover; }
    
    #chat-placeholder, #chat-loader { text-align: center; margin: auto; color: var(--light-text); opacity: 0.5; }

    /* NUEVO: Estilo para el estado del mensaje (visto/entregado) */
    .mensaje-leido-status { font-size: 0.8em; opacity: 0.8; margin-left: 5px; }
    .leido-por-todos { color: #3498db; /* Un color azul para "visto" */ }

    .destinatarios-display { background-color: rgba(0,0,0,0.2); min-height: 40px; padding: 5px; border-radius: 5px; display: flex; flex-wrap: wrap; gap: 5px; align-items: center; }
    .destinatario-tag { background-color: var(--primary-color); color: var(--dark-text); padding: 2px 8px; border-radius: 4px; font-size: 0.9em; }
    #modalSeleccionarDestinatarios .modal-body { max-height: 60vh; overflow-y: auto; }
    .usuario-item { display: flex; align-items: center; padding: 8px; cursor: pointer; border-radius: 5px; transition: background-color 0.2s ease; }
    .usuario-item:hover { background-color: rgba(255,255,255,0.1); }
    .usuario-item img { width: 30px; height: 30px; border-radius: 50%; margin-right: 10px; }
</style>

<div class="main-header">
    <h1><?php echo $page_title; ?></h1>
    <button class="btn-add-new" id="btn-abrir-modal-principal"><i class="fa-solid fa-plus"></i> Nuevo Memorando</button>
</div>

<div class="mensajeria-container">
    <div class="lista-conversaciones" id="lista-conversaciones-container"></div>
    <div class="chat-container">
        <div class="chat-header" id="chat-header-container" style="display:none;"><h5 id="chat-asunto"></h5></div>
        <div class="chat-body" id="chat-body-container">
            <div id="chat-placeholder"><i class="fa-solid fa-comments fa-3x"></i><p class="mt-2">Selecciona una conversación para empezar.</p></div>
            <div id="chat-loader" style="display:none;"><div class="spinner-border" role="status"><span class="visually-hidden">Cargando...</span></div></div>
        </div>
        <div class="chat-footer" id="chat-footer-container" style="display:none;">
            <form id="form-enviar-mensaje"><div class="input-group"><input type="text" class="form-control form-control-dark" id="input-mensaje" placeholder="Escribe un mensaje..." required autocomplete="off"><button class="btn btn-primary" type="submit"><i class="fa-solid fa-paper-plane"></i></button></div></form>
        </div>
    </div>
</div>

<div class="modal fade ami-modal-theme" id="modalNuevoMensaje" tabindex="-1"><div class="modal-dialog modal-lg"><div class="modal-content"><div class="modal-header"><h5 class="modal-title">Redactar Memorando</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><div class="modal-body"><form id="form-crear-conversacion"><div class="ami-form-group mb-3"><label class="ami-form-label">Para:</label><div class="d-flex align-items-center gap-2"><div class="destinatarios-display flex-grow-1" id="destinatarios-tags"><span class="text-white-50 small">Añade destinatarios con el botón +</span></div><button type="button" class="btn btn-outline-light" id="btn-abrir-selector-destinatarios" title="Añadir Destinatarios"><i class="fa-solid fa-plus"></i></button></div></div><div class="ami-form-group mb-3"><label class="ami-form-label">Asunto:</label><input type="text" id="input-asunto" class="form-control" required></div><div class="ami-form-group"><label class="ami-form-label">Mensaje:</label><textarea id="input-primer-mensaje" class="form-control" rows="4" required></textarea></div></form></div><div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button><button type="button" class="btn btn-primary" id="btn-enviar-nuevo">Enviar</button></div></div></div></div>
<div class="modal fade ami-modal-theme" id="modalSeleccionarDestinatarios" tabindex="-1" style="z-index: 1060;"><div class="modal-dialog"><div class="modal-content"><div class="modal-header"><h5 class="modal-title">Seleccionar Destinatarios</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><div class="modal-body"><div class="mb-3"><input type="search" id="input-buscar-usuario" class="form-control" placeholder="Buscar por nombre..."></div><div id="lista-usuarios-container"></div></div><div class="modal-footer d-flex justify-content-between"><button type="button" class="btn btn-info" id="btn-enviar-a-todos"><i class="fa-solid fa-bullhorn"></i> Comunicado a Todos</button><div><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button><button type="button" class="btn btn-primary" id="btn-confirmar-destinatarios">Añadir</button></div></div></div></div></div>


<script>
document.addEventListener('DOMContentLoaded', function() {
    const csrfToken = '<?php echo $_SESSION['csrf_token']; ?>';
    const miUserId = <?php echo $_SESSION['user_id']; ?>;
    let conversacionActivaId = null;
    let todosLosUsuarios = [];
    let destinatariosSeleccionados = new Map();
    let esComunicadoGeneral = false;
    let ultimoMensajeId = 0;
    let chatPollingInterval = null;

    const modalNuevoMensaje = new bootstrap.Modal(document.getElementById('modalNuevoMensaje'));
    const modalSeleccionarDestinatarios = new bootstrap.Modal(document.getElementById('modalSeleccionarDestinatarios'));
    
    // Elementos de la UI
    const listaConvContainer = document.getElementById('lista-conversaciones-container');
    const chatBodyContainer = document.getElementById('chat-body-container');
    const chatPlaceholder = document.getElementById('chat-placeholder');
    const chatLoader = document.getElementById('chat-loader');

    async function fetchAPI(action, params = {}, method = 'GET') {
        const url = new URL('/api/memorandos_ajax.php', window.location.origin);
        let options = { method };
        if (method === 'GET') {
            url.searchParams.append('action', action);
            for (const key in params) { url.searchParams.append(key, params[key]); }
        } else { // POST
            const formData = new FormData();
            formData.append('action', action);
            formData.append('csrf_token', csrfToken);
            for (const key in params) { formData.append(key, params[key]); }
            options.body = formData;
        }
        try {
            const response = await fetch(url, options);
            if (!response.ok) throw new Error(`Error en la API: ${response.statusText}`);
            return response.json();
        } catch (error) {
            console.error('Error en fetchAPI:', error);
            Swal.fire('Error de Conexión', 'No se pudo comunicar con el servidor.', 'error');
            return { success: false, message: 'Error de red.' };
        }
    }
    
    function renderizarConversaciones(conversaciones) {
        const activeId = conversacionActivaId;
        listaConvContainer.innerHTML = '';
        if (!conversaciones || conversaciones.length === 0) {
            listaConvContainer.innerHTML = '<p class="text-center text-white-50 mt-4">No tienes conversaciones.</p>';
            return;
        }

        conversaciones.forEach(c => {
            const fecha = c.fecha_ultimo_mensaje ? new Date(c.fecha_ultimo_mensaje).toLocaleString('es-ES', { day: 'numeric', month: 'short', hour: 'numeric', minute: '2-digit' }) : '';
            const remitente = c.remitente_ultimo_mensaje === '<?php echo htmlspecialchars($usuario_actual['nombre'], ENT_QUOTES, 'UTF-8'); ?>' ? 'Tú' : c.remitente_ultimo_mensaje;
            const iconoTipo = c.tipo === 'Comunicado' ? '<i class="fa-solid fa-bullhorn text-warning me-2"></i>' : '';
            // NUEVO: Añadir punto de notificación
            const notificacion = c.mensajes_no_leidos > 0 ? '<span class="notificacion-punto"></span>' : '';
            const ultimoMsgTexto = c.ultimo_mensaje ? c.ultimo_mensaje.substring(0, 40) + (c.ultimo_mensaje.length > 40 ? '...' : '') : '<i>Conversación iniciada.</i>';

            const item = document.createElement('div');
            item.className = `conversacion-item ${c.id == activeId ? 'active' : ''}`;
            item.dataset.id = c.id;
            item.dataset.asunto = c.asunto;
            item.dataset.tipo = c.tipo;
            item.innerHTML = `
                ${notificacion}
                <div class="d-flex justify-content-between">
                    <h6 class="mb-1 text-truncate">${iconoTipo}${c.asunto}</h6>
                    <small class="text-white-50 text-nowrap">${fecha}</small>
                </div>
                <p class="mb-0 text-white-50" style="font-size: 0.9em;">
                    <strong class="${c.mensajes_no_leidos > 0 ? 'text-white' : ''}">${remitente}:</strong> 
                    <span class="${c.mensajes_no_leidos > 0 ? 'text-white-75' : ''}">${ultimoMsgTexto}</span>
                </p>`;
            listaConvContainer.appendChild(item);
        });
    }

    async function seleccionarConversacion(id, asunto, tipo) {
        if (conversacionActivaId === id) return; // No recargar si ya está activa
        if (chatPollingInterval) clearInterval(chatPollingInterval);

        conversacionActivaId = id;
        
        // CAMBIO: Limpiar el chat y mostrar loader inmediatamente
        chatBodyContainer.innerHTML = '';
        chatLoader.style.display = 'block';
        chatPlaceholder.style.display = 'none';

        document.getElementById('chat-asunto').textContent = asunto;
        ['chat-header-container', 'chat-footer-container'].forEach(elId => document.getElementById(elId).style.display = 'block');
        document.getElementById('chat-footer-container').style.display = tipo === 'Comunicado' ? 'none' : 'block';
        
        document.querySelectorAll('.conversacion-item.active').forEach(el => el.classList.remove('active'));
        const itemActivo = document.querySelector(`.conversacion-item[data-id='${id}']`);
        if (itemActivo) itemActivo.classList.add('active');

        const res = await fetchAPI('cargar_mensajes', { memorando_id: id });
        
        chatLoader.style.display = 'none'; // Ocultar loader
        
        if (res.success) {
            renderizarMensajes(res.data.mensajes);
            await cargarConversaciones(); // Recargar lista para quitar negrita/punto
            chatPollingInterval = setInterval(refrescarMensajesActivos, 5000); // Polling cada 5 seg
        }
    }
    
    function renderizarMensajes(mensajes) {
        chatBodyContainer.innerHTML = ''; // Siempre limpiar antes de renderizar
        ultimoMensajeId = 0;

        if (!mensajes || mensajes.length === 0) {
            chatBodyContainer.innerHTML = '<div id="chat-placeholder"><i class="fa-solid fa-comment-dots fa-2x"></i><p class="mt-2">No hay mensajes en esta conversación.</p></div>';
            return;
        }

        mensajes.forEach(m => {
            const esPropio = m.remitente_id == miUserId;
            const fecha = new Date(m.fecha_envio).toLocaleString('es-ES', { hour: '2-digit', minute: '2-digit' });
            const fotoSrc = m.foto_perfil ? `/uploads/perfiles/${m.foto_perfil}` : '/uploads/perfiles/default.png';
            
            // NUEVO: Lógica para el estado de lectura
            let statusHTML = '';
            if (esPropio) {
                if (m.hasOwnProperty('leido_por_todos')) {
                     statusHTML = m.leido_por_todos
                        ? '<span class="mensaje-leido-status leido-por-todos" title="Visto">✔️</span>'
                        : '<span class="mensaje-leido-status" title="Entregado">✓</span>';
                } else {
                     statusHTML = '<span class="mensaje-leido-status" title="Entregado">✓</span>';
                }
            }

            const msgDiv = document.createElement('div');
            msgDiv.className = `mensaje ${esPropio ? 'propio' : 'ajeno'}`;
            msgDiv.id = `msg-${m.id}`;
            msgDiv.innerHTML = `
                <img src="${fotoSrc}" class="perfil-pic-chat" title="${m.remitente_nombre}">
                <div class="mensaje-burbuja">
                    <p class="mb-1">${m.mensaje}</p>
                    <div class="mensaje-meta text-end d-flex justify-content-end align-items-center">
                        <span>${fecha}</span>
                        ${statusHTML}
                    </div>
                </div>`;
            chatBodyContainer.appendChild(msgDiv); // Usar appendChild para orden cronológico
        });

        if (mensajes.length > 0) {
            ultimoMensajeId = mensajes[mensajes.length - 1].id;
        }

        // CAMBIO: Scroll al final después de renderizar
        chatBodyContainer.scrollTop = chatBodyContainer.scrollHeight;
    }
    
    async function refrescarMensajesActivos(forzarScroll = false) {
        if (!conversacionActivaId || document.visibilityState !== 'visible') return;

        const res = await fetchAPI('cargar_mensajes', { memorando_id: conversacionActivaId });
        if (res.success && res.data.mensajes.length > 0) {
            const nuevoUltimoId = res.data.mensajes[res.data.mensajes.length - 1].id;
            if (nuevoUltimoId > ultimoMensajeId) {
                const estabaScrolleadoAlFinal = (chatBodyContainer.scrollHeight - chatBodyContainer.clientHeight) <= (chatBodyContainer.scrollTop + 5);
                renderizarMensajes(res.data.mensajes);
                if (estabaScrolleadoAlFinal || forzarScroll) {
                    chatBodyContainer.scrollTop = chatBodyContainer.scrollHeight;
                }
            }
        }
    }

    document.getElementById('form-enviar-mensaje').addEventListener('submit', async function(e) {
        e.preventDefault();
        const input = document.getElementById('input-mensaje');
        const mensaje = input.value.trim();
        if (!mensaje || !conversacionActivaId) return;
        
        input.disabled = true;
        const res = await fetchAPI('enviar_mensaje', { memorando_id: conversacionActivaId, mensaje }, 'POST');
        input.value = '';
        input.disabled = false;
        input.focus();
        
        if (res.success) {
            await refrescarMensajesActivos(true); // Forzar scroll en nuestro propio mensaje
            await cargarConversaciones();
        } else {
            Swal.fire('Error', res.message, 'error');
        }
    });

    listaConvContainer.addEventListener('click', function(e){
        const item = e.target.closest('.conversacion-item');
        if(item){
            seleccionarConversacion(parseInt(item.dataset.id), item.dataset.asunto, item.dataset.tipo);
        }
    });

    async function cargarConversaciones() {
        const res = await fetchAPI('cargar_conversaciones');
        if (res.success) renderizarConversaciones(res.data);
    }
    
    // Polling global para la lista de conversaciones (más eficiente que recargar todo)
    setInterval(async () => {
        if (document.visibilityState === 'visible') {
            await cargarConversaciones();
        }
    }, 10000); // Cada 10 segundos
    
    // Carga inicial
    cargarConversaciones();

    // --- Lógica de los modales (sin cambios funcionales mayores) ---
    function renderizarListaUsuarios(filtro = '') {
        const container = document.getElementById('lista-usuarios-container');
        container.innerHTML = '';
        const usuariosFiltrados = todosLosUsuarios.filter(u => u.nombre.toLowerCase().includes(filtro.toLowerCase()));
        usuariosFiltrados.forEach(u => {
            const isChecked = destinatariosSeleccionados.has(u.id);
            const fotoSrc = u.foto_perfil ? `/uploads/perfiles/${u.foto_perfil}` : '/uploads/perfiles/default.png';
            container.innerHTML += `<div class="usuario-item"><div class="form-check form-check-inline w-100"><input class="form-check-input" type="checkbox" id="user-${u.id}" value="${u.id}" ${isChecked ? 'checked' : ''}><label class="form-check-label w-100 d-flex align-items-center" for="user-${u.id}"><img src="${fotoSrc}" class="me-2" style="width:30px;height:30px;border-radius:50%;object-fit:cover;">${u.nombre}</label></div></div>`;
        });
    }

    function actualizarTagsDestinatarios() {
        const container = document.getElementById('destinatarios-tags');
        container.innerHTML = esComunicadoGeneral ? '<span class="destinatario-tag bg-info text-dark">COMUNICADO A TODA LA EMPRESA</span>' : '';
        if (!esComunicadoGeneral && destinatariosSeleccionados.size > 0) {
            destinatariosSeleccionados.forEach(nombre => {
                container.innerHTML += `<span class="destinatario-tag">${nombre}</span>`;
            });
        } else if (!esComunicadoGeneral) {
            container.innerHTML = '<span class="text-white-50 small">Añade destinatarios con el botón +</span>';
        }
    }

    document.getElementById('btn-abrir-modal-principal').addEventListener('click', () => {
        document.getElementById('form-crear-conversacion').reset();
        destinatariosSeleccionados.clear();
        esComunicadoGeneral = false;
        actualizarTagsDestinatarios();
        modalNuevoMensaje.show();
    });

    document.getElementById('btn-abrir-selector-destinatarios').addEventListener('click', async () => {
        if (todosLosUsuarios.length === 0) {
            const res = await fetchAPI('cargar_todos_los_usuarios');
            if(res.success) todosLosUsuarios = res.data;
        }
        renderizarListaUsuarios();
        modalSeleccionarDestinatarios.show();
    });

    document.getElementById('input-buscar-usuario').addEventListener('input', function() { renderizarListaUsuarios(this.value); });

    document.getElementById('btn-confirmar-destinatarios').addEventListener('click', () => {
        destinatariosSeleccionados.clear();
        esComunicadoGeneral = false;
        document.querySelectorAll('#lista-usuarios-container input:checked').forEach(input => {
            const id = parseInt(input.value);
            const nombre = todosLosUsuarios.find(u => u.id === id)?.nombre;
            if (nombre) destinatariosSeleccionados.set(id, nombre);
        });
        actualizarTagsDestinatarios();
        modalSeleccionarDestinatarios.hide();
    });

    document.getElementById('btn-enviar-a-todos').addEventListener('click', () => {
        destinatariosSeleccionados.clear();
        esComunicadoGeneral = true;
        actualizarTagsDestinatarios();
        modalSeleccionarDestinatarios.hide();
    });

    document.getElementById('btn-enviar-nuevo').addEventListener('click', async function() {
        const asunto = document.getElementById('input-asunto').value.trim();
        const mensaje = document.getElementById('input-primer-mensaje').value.trim();
        const destinatarios = Array.from(destinatariosSeleccionados.keys());
        if (!asunto || !mensaje) { Swal.fire('Atención', 'Asunto y mensaje son obligatorios.', 'warning'); return; }
        if (!esComunicadoGeneral && destinatarios.length === 0) { Swal.fire('Atención', 'Debes seleccionar destinatarios o marcar como comunicado.', 'warning'); return; }
        const params = { asunto, mensaje, es_comunicado: esComunicadoGeneral, destinatarios: JSON.stringify(destinatarios) };
        const res = await fetchAPI('crear_conversacion', params, 'POST');
        if (res.success) {
            modalNuevoMensaje.hide();
            Swal.fire('¡Éxito!', 'Memorando enviado.', 'success');
            await cargarConversaciones();
        } else { Swal.fire('Error', res.message, 'error'); }
    });
});
</script>

<?php include_once 'templates/footer.php'; ?>