<?php
require_once '../administracion/includes/seguridad.php';

// Ajusta el permiso si es necesario para tu sistema de roles
if (!puede('gestionar_inventario_admin')) {
    header('Location: ../login.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Importar Inventario - Sistema</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        /* Estilos (sin cambios, se mantienen los originales) */
        .upload-area{border:2px dashed #dee2e6;border-radius:10px;padding:40px;text-align:center;transition:all .3s ease;background:#f8f9fa;cursor:pointer}.upload-area:hover{border-color:#0d6efd;background:#e7f3ff}.upload-area.dragover{border-color:#0d6efd;background:#e7f3ff;transform:scale(1.02)}.sheet-card{border:2px solid #e9ecef;border-radius:8px;padding:15px;margin:10px 0;transition:all .3s ease;cursor:pointer;background:#fff}.sheet-card:hover{border-color:#0d6efd;transform:translateY(-2px);box-shadow:0 4px 8px rgba(0,0,0,.1)}.sheet-card.selected{border-color:#0d6efd;background:#e7f3ff}.progress-container,.preview-container,.results-container,.multi-sheet-selector{display:none;margin-top:20px}.file-info{background:#e9ecef;padding:15px;border-radius:8px;margin-top:15px}.step-indicator{display:flex;justify-content:center;margin-bottom:30px;flex-wrap:wrap}.step{display:flex;align-items:center;padding:0 15px;margin:5px 0}.step-circle{width:30px;height:30px;border-radius:50%;background:#dee2e6;color:#6c757d;display:flex;align-items:center;justify-content:center;margin-right:10px;font-size:14px;font-weight:700}.step.active .step-circle{background:#0d6efd;color:#fff}.step.completed .step-circle{background:#198754;color:#fff}.table-responsive{max-height:400px;overflow-y:auto}.duplicados-list,.error-details,.omitted-details{max-height:300px;overflow-y:auto;border:1px solid #dee2e6;border-radius:5px;padding:15px;margin-top:15px;background-color:#f8f9fa}.error-details{border-color:#f5c6cb;background-color:#f8d7da}.duplicados-list{border-color:#ffeeba;background-color:#fff3cd}
    </style>
</head>
<body>
    <script>
        const CSRF_TOKEN = '<?php echo $_SESSION['csrf_token']; ?>';
    </script>
    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-12">
                <div class="card shadow-sm">
                    <div class="card-header bg-primary text-white">
                        <h4 class="mb-0"><i class="fas fa-boxes me-2"></i>Importar Inventario desde Excel</h4>
                    </div>
                    <div class="card-body">
                        <div class="step-indicator">
                            <div class="step active" id="step1"><div class="step-circle">1</div><span>Archivo</span></div>
                            <div class="step" id="step2"><div class="step-circle">2</div><span>Hojas</span></div>
                            <div class="step" id="step3"><div class="step-circle">3</div><span>Mapeo</span></div>
                            <div class="step" id="step4"><div class="step-circle">4</div><span>Importar</span></div>
                            <div class="step" id="step5"><div class="step-circle">5</div><span>Resultados</span></div>
                        </div>

                        <div id="upload-section">
                            <div class="upload-area" id="uploadArea">
                                <i class="fas fa-cloud-upload-alt fa-3x text-muted mb-3"></i>
                                <h5>Arrastra tu archivo Excel aquí</h5>
                                <input type="file" id="fileInput" class="d-none" accept=".xlsx,.xls,.csv">
                                <button type="button" class="btn btn-outline-primary" id="selectFileBtn"><i class="fas fa-folder-open me-2"></i>Seleccionar Archivo</button>
                            </div>
                            <div class="file-info" id="fileInfo" style="display: none;">
                                <div class="row align-items-center">
                                    <div class="col-md-5"><strong>Archivo:</strong> <span id="fileName"></span></div>
                                    <div class="col-md-2"><strong>Tamaño:</strong> <span id="fileSize"></span></div>
                                    <div class="col-md-2"><strong>Hojas:</strong> <span id="sheetsCount"></span></div>
                                    <div class="col-md-3"><strong>Estado:</strong> <span id="fileStatus"></span></div>
                                </div>
                            </div>
                        </div>

                        <div class="multi-sheet-selector" id="multiSheetSelector">
                           <h5 class="text-center mt-3">Selecciona la hoja que deseas importar</h5>
                           <div class="row justify-content-center" id="sheetsContainer"></div>
                           <div class="text-center mt-3">
                                <button type="button" class="btn btn-success btn-lg" id="processSelectedSheets" disabled>
                                    <i class="fas fa-cogs me-2"></i>Procesar Hoja Seleccionada
                                </button>
                            </div>
                        </div>

                        <div class="preview-container" id="previewContainer">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h5><i class="fas fa-table me-2"></i>Vista Previa y Mapeo de Columnas</h5>
                                <div>
                                    <button type="button" class="btn btn-warning me-2" id="backToSheetSelection"><i class="fas fa-arrow-left me-2"></i>Volver</button>
                                    <button type="button" class="btn btn-success" id="importBtn"><i class="fas fa-download me-2"></i>Iniciar Importación</button>
                                </div>
                            </div>
                            
                            <div class="alert alert-info">
                                <strong><i class="fas fa-map me-2"></i>Asigna las columnas de tu Excel a los campos de la base de datos.</strong>
                                <small class="d-block">Los campos con * son obligatorios.</small>
                                <div class="row mt-2 g-2">
                                    <div class="col-md-2"><label class="form-label small">SKU *</label><select class="form-select form-select-sm" id="mapSku"></select></div>
                                    <div class="col-md-3"><label class="form-label small">PRODUCTO *</label><select class="form-select form-select-sm" id="mapNombre"></select></div>
                                    <div class="col-md-2"><label class="form-label small">CANTIDAD *</label><select class="form-select form-select-sm" id="mapCantidad"></select></div>
                                    <div class="col-md-2"><label class="form-label small">CATEGORÍA</label><select class="form-select form-select-sm" id="mapCategoria"></select></div>
                                    <div class="col-md-3"><label class="form-label small">STOCK MÍNIMO</label><select class="form-select form-select-sm" id="mapStockMinimo"></select></div>
                                    <div class="col-md-4"><label class="form-label small">DESCRIPCIÓN</label><select class="form-select form-select-sm" id="mapDescripcion"></select></div>
                                </div>
                            </div>

                            <div class="table-responsive">
                                <table class="table table-sm table-striped" id="previewTable">
                                    <thead class="table-dark"><tr id="previewHeaders"></tr></thead>
                                    <tbody id="previewBody"></tbody>
                                </table>
                            </div>
                        </div>

                        <div class="progress-container" id="progressContainer"></div>
                        <div class="results-container" id="resultsContainer"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
    <script>
        let currentFile = null, workbook = null, selectedSheets = new Set(), combinedData = null;

        document.addEventListener('DOMContentLoaded', () => {
            const fileInput=document.getElementById('fileInput'),selectFileBtn=document.getElementById('selectFileBtn'),uploadArea=document.getElementById('uploadArea');
            fileInput?.addEventListener('change', e => handleFile(e.target.files[0]));
            selectFileBtn?.addEventListener('click',()=>fileInput.click());
            uploadArea?.addEventListener('dragover', e => { e.preventDefault(); uploadArea.classList.add('dragover'); });
            uploadArea?.addEventListener('dragleave', () => uploadArea.classList.remove('dragover'));
            uploadArea?.addEventListener('drop', e => { e.preventDefault(); uploadArea.classList.remove('dragover'); handleFile(e.dataTransfer.files[0]); });
            document.getElementById('processSelectedSheets')?.addEventListener('click', processSelectedSheets);
            document.getElementById('backToSheetSelection')?.addEventListener('click', backToSheetSelection);
            document.getElementById('importBtn')?.addEventListener('click', startImport);
        });

        function handleFile(file) {
            if (!file) return;
            currentFile = file;
            const fileInfo = document.getElementById('fileInfo');
            fileInfo.style.display = 'block';
            document.getElementById('fileName').textContent = file.name;
            document.getElementById('fileSize').textContent = (file.size / 1024 / 1024).toFixed(2) + ' MB';
            document.getElementById('fileStatus').innerHTML = '<span class="badge bg-warning">Procesando...</span>';
            const reader = new FileReader();
            reader.onload = e => {
                workbook = XLSX.read(e.target.result, {type: 'binary', cellDates: true});
                document.getElementById('sheetsCount').textContent = workbook.SheetNames.length;
                document.getElementById('fileStatus').innerHTML = '<span class="badge bg-success">Listo</span>';
                displaySheetSelector(workbook.SheetNames);
                updateStep(2);
            };
            reader.readAsBinaryString(file);
        }

        function displaySheetSelector(sheetNames) {
            const container = document.getElementById('sheetsContainer');
            container.innerHTML = '';
            sheetNames.forEach(name => {
                const card = document.createElement('div');
                card.className = 'col-md-4';
                card.innerHTML = `<div class="sheet-card" data-sheet="${name}" onclick="toggleSheetSelection('${name.replace(/'/g, "\\'")}')"><h5><i class="fas fa-file-excel text-success"></i> ${name}</h5></div>`;
                container.appendChild(card);
            });
            document.getElementById('upload-section').style.display = 'none';
            document.getElementById('multiSheetSelector').style.display = 'block';
        }

        function toggleSheetSelection(sheetName) {
            selectedSheets.clear(); selectedSheets.add(sheetName);
            document.querySelectorAll('.sheet-card').forEach(c => c.classList.remove('selected'));
            document.querySelector(`[data-sheet="${sheetName}"]`).classList.add('selected');
            document.getElementById('processSelectedSheets').disabled = false;
        }

        function processSelectedSheets() {
            if (selectedSheets.size === 0) return;
            const sheetName = selectedSheets.values().next().value;
            const worksheet = workbook.Sheets[sheetName];
            const jsonData = XLSX.utils.sheet_to_json(worksheet, { header: 1, defval: "" });
            
            if (jsonData.length < 2) { alert('La hoja seleccionada está vacía o solo tiene encabezados.'); return; }

            combinedData = jsonData;
            const headers = combinedData[0];
            const dataRows = combinedData.slice(1, 11);

            setupColumnMapping(headers);
            displayPreview(headers, dataRows);
            document.getElementById('multiSheetSelector').style.display = 'none';
            document.getElementById('previewContainer').style.display = 'block';
            updateStep(3);
        }
        
        function backToSheetSelection(){
            document.getElementById('previewContainer').style.display='none';
            document.getElementById('multiSheetSelector').style.display='block';
            updateStep(2);
        }

        // #### FUNCIÓN DE MAPEO CORREGIDA ####
        function setupColumnMapping(headers) {
            const mappers = {
                mapSku: ["sku"],
                mapNombre: ["producto", "nombre"],
                mapCantidad: ["cantidad"],
                mapCategoria: ["categoria"],
                mapStockMinimo: ["stock", "minimo", "mínimo"],
                mapDescripcion: ["descripcion", "descripción"]
            };

            Object.keys(mappers).forEach(mapperId => {
                const select = document.getElementById(mapperId);
                select.innerHTML = '<option value="">No mapear</option>';
                let bestMatch = -1;
                const keywords = mappers[mapperId];

                headers.forEach((header, index) => {
                    const option = document.createElement('option');
                    option.value = index;
                    option.textContent = header || `Columna ${index + 1}`;
                    select.appendChild(option);
                    if (header && keywords.some(key => header.toLowerCase().includes(key))) {
                        bestMatch = index;
                    }
                });
                if(bestMatch !== -1) select.value = bestMatch;
            });
        }

        function displayPreview(headers, dataRows) {
            const previewHeaders = document.getElementById('previewHeaders');
            const previewBody = document.getElementById('previewBody');
            previewHeaders.innerHTML = headers.map(h => `<th>${h || ''}</th>`).join('');
            previewBody.innerHTML = dataRows.map(row => `<tr>${row.map(cell => {
                let content = cell instanceof Date ? cell.toLocaleDateString() : (cell || '');
                return `<td>${String(content).substring(0, 50)}</td>`;
            }).join('')}</tr>`).join('');
        }

        // #### FUNCIÓN DE IMPORTACIÓN CORREGIDA ####
        function startImport() {
            const mapping = {
                sku: document.getElementById('mapSku').value,
                nombre: document.getElementById('mapNombre').value,
                cantidad: document.getElementById('mapCantidad').value,
                categoria: document.getElementById('mapCategoria').value,
                stock_minimo: document.getElementById('mapStockMinimo').value,
                descripcion: document.getElementById('mapDescripcion').value
            };

            if (mapping.sku === '' || mapping.nombre === '' || mapping.cantidad === '') {
                alert('Los campos SKU, PRODUCTO y CANTIDAD son obligatorios.');
                return;
            }

            const dataRows = combinedData.slice(1);
            document.getElementById('previewContainer').style.display = 'none';
            document.getElementById('progressContainer').style.display = 'block';
            updateStep(4);
            
            processBatch(dataRows, mapping, 0, { success: 0, errors: 0, processed: 0, errorsList: [] });
        }

        function processBatch(allRows, mapping, startIndex, stats) {
            const batchSize = 100;
            const batch = allRows.slice(startIndex, startIndex + batchSize);
            if (batch.length === 0) {
                showResults(stats);
                return;
            }

            const batchData = batch.map((row, i) => {
                const producto = { fila_original: startIndex + i + 2 };
                for (const key in mapping) {
                    if (mapping[key] !== '') producto[key] = row[mapping[key]];
                }
                return producto;
            });

            const formData = new FormData();
            formData.append('action', 'importar_inventario_lote');
            formData.append('productos', JSON.stringify(batchData));
            formData.append('csrf_token', CSRF_TOKEN);

            fetch('ajax_inventario.php', { method: 'POST', body: formData })
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        stats.processed += data.stats.processed;
                        stats.success += data.stats.success;
                        stats.errors += data.stats.errors;
                        stats.errorsList.push(...(data.stats.errorsList || []));
                        
                        // Actualizar progreso (opcional)
                        const percent = Math.round(( (startIndex + batch.length) / allRows.length) * 100);
                        document.getElementById('progressContainer').innerHTML = `
                            <div class="progress">
                              <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" style="width: ${percent}%" aria-valuenow="${percent}" aria-valuemin="0" aria-valuemax="100">${percent}%</div>
                            </div>
                            <p class="text-center mt-2">Procesando ${startIndex + batch.length} de ${allRows.length} filas...</p>
                        `;

                        processBatch(allRows, mapping, startIndex + batchSize, stats);
                    } else {
                        throw new Error(data.message);
                    }
                })
                .catch(err => {
                    alert('Error crítico durante la importación: ' + err.message);
                });
        }
        
        function showResults(stats) {
            updateStep(5);
            document.getElementById('progressContainer').style.display = 'none';
            const resultsContainer = document.getElementById('resultsContainer');
            resultsContainer.style.display = 'block';
            resultsContainer.innerHTML = `
                <div class="alert alert-success">
                    <h5><i class="fas fa-check-circle"></i> ¡Importación Completada!</h5>
                    <div class="d-flex justify-content-around text-center">
                        <div><strong>Procesados</strong><p class="h3">${stats.processed}</p></div>
                        <div><strong class="text-success">Correctos</strong><p class="h3 text-success">${stats.success}</p></div>
                        <div><strong class="text-danger">Errores</strong><p class="h3 text-danger">${stats.errors}</p></div>
                    </div>
                </div>
                ${(stats.errorsList.length > 0) ? `<h6><i class="fas fa-times-circle text-danger"></i> Errores</h6><div class="error-details">${stats.errorsList.map(e => `<div class="p-1"><small>Fila ${e.fila}: ${e.error}</small></div>`).join('')}</div>` : ''}
                <div class="text-center mt-4">
                    <button class="btn btn-primary" onclick="location.reload()"><i class="fas fa-redo"></i> Nueva Importación</button>
                </div>
            `;
        }
        
        function updateStep(stepNumber) {
            document.querySelectorAll('.step').forEach(s => s.classList.remove('active', 'completed'));
            for (let i = 1; i < stepNumber; i++) document.getElementById(`step${i}`)?.classList.add('completed');
            document.getElementById(`step${stepNumber}`)?.classList.add('active');
        }

    </script>
</body>
</html>