<?php
require_once 'includes/seguridad.php';
$page_title = 'Gestión de Empleados';
include_once 'templates/header.php';

if (!puede('gestionar_empleados_basico') && !puede('gestionar_empleados_avanzado')) {
    echo "<main class='ami-content'><div class='info-card'><h1>Acceso Denegado</h1></div></main>";
    include_once 'templates/footer.php';
    exit();
}

$permiso_avanzado = puede('gestionar_empleados_avanzado');
$permiso_basico = puede('gestionar_empleados_basico');

$roles_json = json_encode($conn->query("SELECT id, nombre FROM roles WHERE clave != 'superadmin' ORDER BY nombre ASC")->fetchAll(PDO::FETCH_ASSOC));
$sedes_json = json_encode($conn->query("SELECT id, nombre FROM sedes ORDER BY nombre ASC")->fetchAll(PDO::FETCH_ASSOC));
$permisos_json = json_encode($conn->query("SELECT id, clave, descripcion FROM permisos ORDER BY clave ASC")->fetchAll(PDO::FETCH_ASSOC));
?>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.12/cropper.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.12/cropper.min.js"></script>

<style>
    .dashboard-filters { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1.5rem; margin-bottom: 2rem; }
    .stat-card { background: var(--card-bg); padding: 1.5rem; border-radius: 12px; text-align: center; }
    .stat-card .stat-value { font-size: 2.5rem; font-weight: 700; color: var(--primary-color); }
    .stat-card .stat-label { font-size: 1rem; opacity: 0.8; }
    .filter-card { background: var(--card-bg); padding: 1rem; border-radius: 12px; }
    .filter-card label { font-size: 0.8rem; text-transform: uppercase; opacity: 0.7; margin-bottom: 0.5rem; display: block;}
    .toolbar { display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem; flex-wrap: wrap; gap: 1rem;}
    #resultados-conteo { opacity: 0.8; }
    .profile-pic-table { width: 45px; height: 45px; border-radius: 50%; object-fit: cover; border: 2px solid var(--border-color); }
    #cropper-container { display: none; margin-top: 1rem; background: #000; max-height: 400px; }
    #cropper-image { max-width: 100%; display: block; }
    #profile-pic-preview { width: 120px; height: 120px; border-radius: 50%; object-fit: cover; border: 3px solid var(--border-color); cursor: pointer; background-color: rgba(0,0,0,0.3); }
    .acceso-sistema-info { background: rgba(var(--primary-color-rgb), 0.1); padding: 1rem; border-radius: 8px; margin-bottom: 1rem; }
    .acceso-sistema-info small { opacity: 0.8; }
    .permisos-seccion h6 {
        color: var(--primary-color);
        margin-top: 1rem;
        margin-bottom: 0.5rem;
        padding-bottom: 0.5rem;
        border-bottom: 1px solid var(--border-color);
    }
</style>

<div class="main-header">
    <h1><?php echo $page_title; ?></h1>
</div>

<div class="dashboard-filters">
    <div class="stat-card">
        <div id="total-empleados" class="stat-value">0</div>
        <div class="stat-label">Total Empleados</div>
    </div>
    <div class="filter-card">
        <label for="filtroCargo">Filtrar por Cargo</label>
        <select id="filtroCargo" class="form-select form-control-dark"></select>
    </div>
    <div class="filter-card">
        <label for="filtroSede">Filtrar por Sede</label>
        <select id="filtroSede" class="form-select form-control-dark"></select>
    </div>
</div>

<div class="info-card">
    <div class="toolbar">
        <div>
            <input type="text" id="searchInput" class="form-control form-control-dark" placeholder="Buscar por nombre o cédula...">
            <small id="resultados-conteo" class="form-text text-white-50 mt-1 d-block"></small>
        </div>
        <?php if (puede('gestionar_empleados_basico')): ?>
            <button class="btn-add-new" onclick="abrirModalEmpleado('agregar')">
                <i class="fa-solid fa-plus"></i> Registrar Empleado
            </button>
        <?php endif; ?>
    </div>
    <table class="ami-table">
        <thead>
            <tr><th>Foto</th><th>Nombre</th><th>Cédula</th><th>Cargo / Rol</th><th>Sedes</th><th>Acceso</th><th style="text-align: center;">Acciones</th></tr>
        </thead>
        <tbody id="empleadosTableBody"></tbody>
    </table>
</div>

<div class="ami-modal" id="modalEmpleado">
  <div class="ami-modal-dialog modal-xl">
    <div class="ami-modal-content">
      <div class="ami-modal-header"><h5 class="ami-modal-title" id="modalEmpleadoTitle"></h5><button type="button" class="ami-btn-close" onclick="ocultarModal('modalEmpleado')">&times;</button></div>
      <div class="ami-modal-body" style="max-height: 80vh; overflow-y: auto;">
        <form id="formEmpleado" enctype="multipart/form-data">
          <input type="hidden" name="action" id="form_action">
          <input type="hidden" name="id" id="empleado_id">
          <input type="hidden" name="foto_perfil_base64" id="foto_perfil_base64">
          <input type="hidden" name="csrf_token" id="csrf_token_input">
          
          <div class="text-center mb-3">
             <img src="/uploads/perfiles/default.png" id="profile-pic-preview" title="Haga clic para cambiar la foto">
             <input type="file" id="foto_input" accept="image/png, image/jpeg, image/gif" style="display:none;">
          </div>
          
          <h5 class="text-white-50">Datos Personales y Laborales</h5><hr style="border-color: var(--border-color);">
          <div class="row">
            <div class="col-md-6 ami-form-group mb-3"><label class="ami-form-label">Nombre Completo:</label><input type="text" name="nombre" class="ami-form-control" required></div>
            <div class="col-md-6 ami-form-group mb-3"><label class="ami-form-label">Cédula:</label><input type="text" name="cedula" class="ami-form-control" required></div>
            <div class="col-md-6 ami-form-group mb-3"><label class="ami-form-label">Teléfono:</label><input type="text" name="telefono" class="ami-form-control"></div>
            <div class="col-md-6 ami-form-group mb-3"><label class="ami-form-label">Fecha de Ingreso:</label><input type="text" name="fecha_ingreso" class="ami-form-control" placeholder="dd/mm/aaaa"></div>
            <div class="col-md-6 ami-form-group mb-3"><label class="ami-form-label">Tipo de Contrato:</label><input type="text" name="tipo_contrato" class="ami-form-control"></div>
            <div class="col-md-6 ami-form-group mb-3"><label class="ami-form-label">Salario Base:</label><input type="number" step="0.01" name="salario_base" class="ami-form-control"></div>
            <div class="col-md-12 ami-form-group mb-3"><label class="ami-form-label">Dirección:</label><textarea name="direccion" class="ami-form-control" rows="2"></textarea></div>
            <div class="col-md-12 ami-form-group mb-3"><label class="ami-form-label">Contacto de Emergencia:</label><input type="text" name="contacto_emergencia" class="ami-form-control"></div>
          </div>
          
          <div class="rol-sedes-seccion">
              <h5 class="text-white-50">Cargo y Asignación</h5><hr style="border-color: var(--border-color);">
              <div class="row">
                <div class="col-md-6 ami-form-group mb-3">
                    <label class="ami-form-label">Cargo (Rol):</label>
                    <select name="rol_id" class="ami-form-control" id="modal-rol-select"></select>
                </div>
                <div class="col-md-6 ami-form-group mb-3">
                    <label class="ami-form-label">Sedes Asignadas:</label>
                    <div class="permisos-container" id="sedes-container"></div>
                </div>
              </div>
          </div>
          
          <div class="acceso-sistema-seccion" id="seccionAccesoSistema" style="display: none;">
              <h5 class="text-white-50">Acceso al Sistema</h5><hr style="border-color: var(--border-color);">
              
              <div class="acceso-sistema-info">
                  <small><i class="fa-solid fa-info-circle"></i> <strong>Acceso al Sistema:</strong> Al completar estos campos, el empleado podrá iniciar sesión en el sistema con las credenciales asignadas.</small>
              </div>
              
              <div class="row">
                <div class="col-md-6 ami-form-group mb-3">
                    <label class="ami-form-label">Usuario:</label>
                    <input type="text" name="usuario" class="ami-form-control" placeholder="Nombre de usuario para login">
                </div>
                <div class="col-md-6 ami-form-group mb-3">
                    <label class="ami-form-label">Contraseña:</label>
                    <input type="password" name="password" class="ami-form-control" placeholder="Contraseña de acceso">
                </div>
              </div>
          </div>
          
          <hr style="border-color: var(--border-color); margin: 1.5rem 0;">
          <button type="submit" class="ami-btn ami-btn-primary" id="modalEmpleadoSubmit">Guardar</button>
        </form>
      </div>
    </div>
  </div>
</div>

<div class="ami-modal" id="modalCropper">
    <div class="ami-modal-dialog">
        <div class="ami-modal-content">
            <div class="ami-modal-header">
                <h5 class="ami-modal-title">Recortar Foto de Perfil</h5>
                <button type="button" class="ami-btn-close" onclick="cancelarRecorte()">&times;</button>
            </div>
            <div class="ami-modal-body">
                <div id="cropper-container">
                    <img id="cropper-image" src="" style="max-width: 100%;">
                </div>
                <hr style="border-color: var(--border-color); margin: 1.5rem 0;">
                <button type="button" class="ami-btn ami-btn-primary" id="crop-button">Aceptar y Recortar</button>
                <button type="button" class="ami-btn" onclick="cancelarRecorte()">Cancelar</button>
            </div>
        </div>
    </div>
</div>

<?php if ($permiso_avanzado): ?>
<div class="ami-modal" id="modalPermisosUsuario">
    <div class="ami-modal-dialog modal-lg">
        <div class="ami-modal-content">
            <div class="ami-modal-header">
                <h5 class="ami-modal-title">Permisos para <span id="permisosUserName" class="text-primary"></span></h5>
                <button type="button" class="ami-btn-close" onclick="ocultarModal('modalPermisosUsuario')">&times;</button>
            </div>
            <div class="ami-modal-body" style="max-height: 80vh; overflow-y: auto;">
                <form id="formPermisosUsuario">
                    <input type="hidden" name="action" value="guardar_permisos_usuario">
                    <input type="hidden" name="usuario_id" id="permisos_usuario_id">
                    <input type="hidden" name="csrf_token" id="csrf_token_permisos">

                    <p class="mb-3">
                        Empleado con rol: <strong id="permisosUserRole" class="badge bg-secondary"></strong>
                    </p>
                    
                    <div class="permisos-seccion">
                        <h6><i class="fa-solid fa-user-shield"></i> Permisos Heredados del Rol (Fijos)</h6>
                        <p><small class="text-white-50">Estos permisos vienen con el rol y no se pueden modificar aquí.</small></p>
                        <div class="permisos-container" id="permisos-rol-container">
                            </div>
                    </div>
                    
                    <div class="permisos-seccion mt-4">
                        <h6><i class="fa-solid fa-plus-circle"></i> Permisos Especiales (Adicionales)</h6>
                        <p><small class="text-white-50">Otorga permisos adicionales que el rol de este usuario normalmente no tiene.</small></p>
                        <div class="permisos-container" id="permisos-especiales-container">
                            </div>
                    </div>

                    <hr style="border-color: var(--border-color); margin: 1.5rem 0;">
                    <button type="submit" class="ami-btn ami-btn-primary">Guardar Permisos Especiales</button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<script>
const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
const tienePermisoAvanzado = <?php echo json_encode($permiso_avanzado); ?>;
const tienePermisoBasico = <?php echo json_encode($permiso_basico); ?>;
let todosLosEmpleados = [], todosLosRoles = [], todasLasSedes = [], todosLosPermisos = [];
let cropper = null;
let datosOriginales = {};

// Utilidades
const Utils = {
    formatearFechaParaEnvio(fecha) {
        if (!fecha) return '';
        const partes = fecha.split('/');
        return partes.length === 3 ? `${partes[2]}-${partes[1].padStart(2, '0')}-${partes[0].padStart(2, '0')}` : fecha;
    },
    formatearFechaParaMostrar(fecha) {
        if (!fecha) return '';
        const partes = fecha.split('-');
        return partes.length === 3 ? `${partes[2]}/${partes[1]}/${partes[0]}` : fecha;
    },
    mostrarLoading(texto = 'Procesando...') {
        Swal.fire({ title: texto, allowOutsideClick: false, didOpen: () => Swal.showLoading() });
    },
    async fetchApi(url, options = {}) {
        try {
            const response = await fetch(url, options);
            if (!response.ok) throw new Error(`HTTP ${response.status}`);
            return await response.json();
        } catch (error) {
            console.error('Error en API:', error);
            throw error;
        }
    }
};

// Inicialización
document.addEventListener('DOMContentLoaded', function() {
    todosLosRoles = <?php echo $roles_json; ?>;
    todasLasSedes = <?php echo $sedes_json; ?>;
    todosLosPermisos = <?php echo $permisos_json; ?>;
    initEventListeners();
    cargarDashboard();
});

function initEventListeners() {
    const elementos = {
        searchInput: document.getElementById('searchInput'),
        filtroCargo: document.getElementById('filtroCargo'),
        filtroSede: document.getElementById('filtroSede'),
        profilePic: document.getElementById('profile-pic-preview'),
        fotoInput: document.getElementById('foto_input'),
        cropButton: document.getElementById('crop-button'),
        formEmpleado: document.getElementById('formEmpleado'),
        csrfTokens: [
            document.getElementById('csrf_token_input'),
            document.getElementById('csrf_token_permisos')
        ]
    };
    elementos.searchInput?.addEventListener('input', renderizarTabla);
    elementos.filtroCargo?.addEventListener('change', renderizarTabla);
    elementos.filtroSede?.addEventListener('change', renderizarTabla);
    elementos.profilePic?.addEventListener('click', () => elementos.fotoInput?.click());
    elementos.fotoInput?.addEventListener('change', handleFotoInputChange);
    elementos.cropButton?.addEventListener('click', aplicarRecorte);
    elementos.formEmpleado?.addEventListener('submit', handleFormSubmit);
    elementos.csrfTokens.forEach(token => { if (token) token.value = csrfToken; });
    if (tienePermisoAvanzado) {
        const formPermisos = document.getElementById('formPermisosUsuario');
        formPermisos?.addEventListener('submit', handlePermisosSubmit);
    }
}

async function cargarDashboard() {
    try {
        const data = await Utils.fetchApi('/api/empleados_ajax.php?action=cargar_dashboard_empleados');
        if (!data.success) { Swal.fire('Error', data.message, 'error'); return; }
        todosLosEmpleados = data.data.empleados;
        document.getElementById('total-empleados').textContent = data.data.total_empleados;
        poblarFiltro('filtroCargo', data.data.roles, 'Todos los Cargos', 'nombre');
        poblarFiltro('filtroSede', data.data.sedes, 'Todas las Sedes', 'nombre');
        renderizarTabla();
    } catch (error) {
        console.error('Error:', error);
        Swal.fire('Error', 'Error de conexión', 'error');
    }
}

function poblarFiltro(elementoId, datos, textoDefault, campo) {
    const elemento = document.getElementById(elementoId);
    if (!elemento) return;
    elemento.innerHTML = `<option value="">${textoDefault}</option>`;
    datos.forEach(item => {
        elemento.innerHTML += `<option value="${item[campo]}">${item[campo]}</option>`;
    });
}

function renderizarTabla() {
    const tablaBody = document.getElementById('empleadosTableBody');
    const filtros = {
        texto: document.getElementById('searchInput').value.toLowerCase(),
        cargo: document.getElementById('filtroCargo').value,
        sede: document.getElementById('filtroSede').value
    };
    const empleadosFiltrados = todosLosEmpleados.filter(empleado => {
        const cumpleTexto = (empleado.nombre || '').toLowerCase().includes(filtros.texto) || (empleado.cedula || '').toLowerCase().includes(filtros.texto);
        const cumpleCargo = !filtros.cargo || (empleado.rol_nombre || '') === filtros.cargo;
        const cumpleSede = !filtros.sede || (empleado.sedes_nombres || '').includes(filtros.sede);
        return cumpleTexto && cumpleCargo && cumpleSede;
    });
    if (empleadosFiltrados.length === 0) {
        tablaBody.innerHTML = '<tr><td colspan="7" class="text-center">No se encontraron empleados.</td></tr>';
    } else {
        tablaBody.innerHTML = empleadosFiltrados.map(empleado => crearFilaEmpleado(empleado)).join('');
    }
    document.getElementById('resultados-conteo').textContent = `Mostrando ${empleadosFiltrados.length} de ${todosLosEmpleados.length} empleados.`;
}

// CORREGIDO: Permitir edición para usuarios básicos
function crearFilaEmpleado(empleado) {
    const fotoSrc = empleado.foto_perfil ? `/uploads/perfiles/${empleado.foto_perfil}` : '/uploads/perfiles/default.png';
    let acciones = '';
    if (tienePermisoAvanzado) {
        acciones = `
            <button class="btn-action" onclick="abrirModalEmpleado('editar', ${empleado.id})" title="Editar"><i class="fa-solid fa-pencil"></i></button>
            <button class="btn-action" onclick='gestionarPermisos(${empleado.id}, "${(empleado.nombre || '').replace(/"/g, '\\"')}")' title="Permisos Especiales"><i class="fa-solid fa-shield-halved"></i></button>
            <button class="btn-action" onclick="cambiarEstado(${empleado.id})" title="Activar/Desactivar"><i class="fa-solid ${empleado.estado ? 'fa-toggle-on' : 'fa-toggle-off'}"></i></button>`;
    } else if (tienePermisoBasico) {
        // CAMBIO AQUÍ: Permitir tanto ver como editar para usuarios básicos
        acciones = `
            <button class="btn-action" onclick="abrirModalEmpleado('editar', ${empleado.id})" title="Editar Información"><i class="fa-solid fa-pencil"></i></button>
            <button class="btn-action" onclick="abrirModalEmpleado('ver', ${empleado.id})" title="Ver Ficha"><i class="fa-solid fa-eye"></i></button>`;
    }
    return `<tr><td><img src="${fotoSrc}" class="profile-pic-table" alt="Foto" onerror="this.src='/uploads/perfiles/default.png'"></td><td>${empleado.nombre}</td><td>${empleado.cedula}</td><td><span class="badge">${empleado.rol_nombre || 'Sin Cargo'}</span></td><td>${empleado.sedes_nombres || 'N/A'}</td><td><span class="badge ${empleado.estado ? 'bg-success' : 'bg-danger'}">${empleado.estado ? 'Activo' : 'Inactivo'}</span></td><td class="text-center">${acciones}</td></tr>`;
}

function ocultarModal(id) {
    if (id === 'modalCropper' && cropper) { cropper.destroy(); cropper = null; document.getElementById('cropper-container').style.display = 'none'; }
    const modalElement = document.getElementById(id);
    if (modalElement) { modalElement.classList.remove('show'); }
}

// CORREGIDO: Control de acceso a sección del sistema
function abrirModalEmpleado(modo, empleadoId = null) {
    const form = document.getElementById('formEmpleado');
    const modalTitle = document.getElementById('modalEmpleadoTitle');
    const modalSubmit = document.getElementById('modalEmpleadoSubmit');
    const seccionAcceso = document.getElementById('seccionAccesoSistema');
    
    form.reset();
    limpiarCropper();
    habilitarFormulario(true);
    
    // CAMBIO: Solo usuarios avanzados pueden ver la sección de acceso al sistema
    seccionAcceso.style.display = tienePermisoAvanzado ? 'block' : 'none';
    
    poblarModalSelects();
    document.getElementById('csrf_token_input').value = csrfToken;
    
    if (modo === 'agregar') {
        configurarModoAgregar(modalTitle, modalSubmit);
        document.getElementById('modalEmpleado').classList.add('show');
    } else {
        cargarDatosEmpleado(empleadoId, modo, modalTitle, modalSubmit, seccionAcceso);
    }
}

function limpiarCropper() {
    if (cropper) { cropper.destroy(); cropper = null; }
    document.getElementById('cropper-container').style.display = 'none';
    document.getElementById('cropper-image').src = '';
    document.getElementById('foto_perfil_base64').value = '';
    document.getElementById('profile-pic-preview').src = '/uploads/perfiles/default.png';
}

function habilitarFormulario(habilitar) {
    const allInputs = document.getElementById('formEmpleado').querySelectorAll('input, select, textarea');
    allInputs.forEach(input => input.disabled = !habilitar);
    document.getElementById('modalEmpleadoSubmit').style.display = habilitar ? 'block' : 'none';
}

function poblarModalSelects() {
    const rolSelect = document.getElementById('modal-rol-select');
    rolSelect.innerHTML = '<option value="">Seleccionar Rol</option>';
    todosLosRoles.forEach(rol => { rolSelect.innerHTML += `<option value="${rol.id}">${rol.nombre}</option>`; });
    const sedeContainer = document.getElementById('sedes-container');
    sedeContainer.innerHTML = '';
    todasLasSedes.forEach(sede => { sedeContainer.innerHTML += `<div class="form-check"><input class="form-check-input" type="checkbox" name="sedes[]" value="${sede.id}" id="sede_${sede.id}"><label class="form-check-label" for="sede_${sede.id}">${sede.nombre}</label></div>`; });
}

function configurarModoAgregar(modalTitle, modalSubmit) {
    document.getElementById('empleado_id').value = '';
    modalTitle.textContent = 'Registrar Nuevo Empleado';
    modalSubmit.textContent = 'Registrar Empleado';
    document.getElementById('form_action').value = 'agregar_empleado';
}

async function cargarDatosEmpleado(empleadoId, modo, modalTitle, modalSubmit, seccionAcceso) {
    try {
        const data = await Utils.fetchApi(`/api/empleados_ajax.php?action=obtener_empleado&id=${empleadoId}`);
        if (!data.success) { Swal.fire('Error', data.message, 'error'); return; }
        const emp = data.data;
        datosOriginales = JSON.parse(JSON.stringify(emp));
        llenarFormularioEmpleado(emp);
        if (modo === 'editar') {
            configurarModoEditar(modalTitle, modalSubmit, seccionAcceso);
        } else {
            configurarModoVer(modalTitle, seccionAcceso);
        }
        document.getElementById('modalEmpleado').classList.add('show');
    } catch (error) {
        console.error('Error:', error);
        Swal.fire('Error', 'Error al cargar los datos del empleado', 'error');
    }
}

// CORREGIDO: No llenar campo de contraseña
function llenarFormularioEmpleado(emp) {
    const form = document.getElementById('formEmpleado');
    for (const key in emp) {
        if (key === 'password') continue; // NUNCA llenar el campo contraseña
        const field = form.querySelector(`[name="${key}"]`);
        if (field && field.type !== 'checkbox') {
            field.value = key === 'fecha_ingreso' ? Utils.formatearFechaParaMostrar(emp[key] || '') : (emp[key] || '');
        }
    }
    document.getElementById('empleado_id').value = emp.id;
    document.querySelectorAll('#sedes-container input[type="checkbox"]').forEach(chk => { chk.checked = emp.sedes && emp.sedes.includes(parseInt(chk.value)); });
    if (emp.foto_perfil) { document.getElementById('profile-pic-preview').src = `/uploads/perfiles/${emp.foto_perfil}`; }
    
    // CAMBIO: Limpiar contraseña y agregar placeholder explicativo
    const passwordField = form.querySelector('[name="password"]');
    if (passwordField) {
        passwordField.value = '';
        passwordField.placeholder = 'Dejar vacío para mantener contraseña actual';
    }
}

// CORREGIDO: Diferenciar permisos para edición
function configurarModoEditar(modalTitle, modalSubmit, seccionAcceso) {
    modalTitle.textContent = 'Editar Empleado';
    modalSubmit.textContent = 'Guardar Cambios';
    document.getElementById('form_action').value = 'editar_empleado';
    
    // CAMBIO: Solo usuarios avanzados ven sección de sistema
    if (tienePermisoAvanzado) {
        seccionAcceso.style.display = 'block';
        const passwordField = document.querySelector('[name="password"]');
        if (passwordField && !document.getElementById('password-help')) {
            const helpText = document.createElement('small');
            helpText.id = 'password-help';
            helpText.className = 'form-text text-white-50';
            helpText.innerHTML = '<i class="fa-solid fa-info-circle"></i> Deje este campo vacío si no desea cambiar la contraseña';
            passwordField.parentNode.appendChild(helpText);
        }
    } else {
        seccionAcceso.style.display = 'none';
    }
}

function configurarModoVer(modalTitle, seccionAcceso) {
    modalTitle.textContent = 'Ficha del Empleado';
    habilitarFormulario(false);
    seccionAcceso.style.display = tienePermisoAvanzado ? 'block' : 'none';
}

function handleFotoInputChange(e) {
    const file = e.target.files?.[0];
    if (!file) return;
    if (!file.type.match(/^image\/(jpeg|jpg|png|gif)$/)) { Swal.fire('Error', 'Solo se permiten archivos de imagen (JPG, PNG, GIF)', 'error'); e.target.value = ''; return; }
    if (file.size > 5 * 1024 * 1024) { Swal.fire('Error', 'El archivo es demasiado grande. Máximo 5MB', 'error'); e.target.value = ''; return; }
    const reader = new FileReader();
    reader.onload = function(event) { mostrarModalCropper(event.target.result); };
    reader.readAsDataURL(file);
    e.target.value = '';
}

function mostrarModalCropper(imageSrc) {
    ocultarModal('modalEmpleado');
    const image = document.getElementById('cropper-image');
    image.src = imageSrc;
    document.getElementById('cropper-container').style.display = 'block';
    document.getElementById('modalCropper').classList.add('show');
    if (cropper) cropper.destroy();
    setTimeout(() => { cropper = new Cropper(image, { aspectRatio: 1, viewMode: 1, background: false, autoCropArea: 0.8, responsive: true, restore: false, guides: true, center: true, highlight: false, cropBoxMovable: true, cropBoxResizable: true, toggleDragModeOnDblclick: false }); }, 100);
}

function aplicarRecorte() {
    if (!cropper) return;
    cropper.getCroppedCanvas({ width: 250, height: 250, imageSmoothingEnabled: true, imageSmoothingQuality: 'high' }).toBlob((blob) => {
        const reader = new FileReader();
        reader.onloadend = () => {
            document.getElementById('foto_perfil_base64').value = reader.result;
            document.getElementById('profile-pic-preview').src = reader.result;
            ocultarModal('modalCropper');
            document.getElementById('modalEmpleado').classList.add('show');
        };
        reader.readAsDataURL(blob);
    }, 'image/jpeg', 0.9);
}

function cancelarRecorte() {
    ocultarModal('modalCropper');
    document.getElementById('modalEmpleado').classList.add('show');
}

function handleFormSubmit(e) {
    e.preventDefault();
    const formData = new FormData(document.getElementById('formEmpleado'));
    if (!formData.get('action')) { Swal.fire('Error', 'Error en el formulario: acción no definida', 'error'); return; }
    if (!formData.get('nombre') || !formData.get('cedula')) { Swal.fire('Error', 'Por favor complete los campos obligatorios (Nombre y Cédula)', 'error'); return; }
    const fechaIngreso = formData.get('fecha_ingreso');
    if (fechaIngreso) { formData.set('fecha_ingreso', Utils.formatearFechaParaEnvio(fechaIngreso)); }
    enviarFormulario(formData);
}

async function enviarFormulario(formData) {
    try {
        Utils.mostrarLoading();
        const data = await Utils.fetchApi('/api/empleados_ajax.php', { method: 'POST', body: formData });
        Swal.close();
        if (data.success) {
            ocultarModal('modalEmpleado');
            await Swal.fire('¡Éxito!', data.message, 'success');
            cargarDashboard();
        } else {
            Swal.fire('Error', data.message, 'error');
        }
    } catch (error) {
        Swal.close();
        console.error('Error:', error);
        Swal.fire('Error', 'Error de conexión', 'error');
    }
}

async function cambiarEstado(id) {
    const result = await Swal.fire({ title: '¿Confirmar cambio?', text: "Se cambiará el estado de acceso para este empleado.", icon: 'warning', showCancelButton: true, confirmButtonText: 'Sí, cambiar', cancelButtonText: 'Cancelar' });
    if (!result.isConfirmed) return;
    try {
        const formData = new FormData();
        formData.append('action', 'cambiar_estado');
        formData.append('id', id);
        formData.append('csrf_token', csrfToken);
        const data = await Utils.fetchApi('/api/empleados_ajax.php', { method: 'POST', body: formData });
        if (data.success) {
            await Swal.fire('¡Cambiado!', 'El estado ha sido actualizado.', 'success');
            cargarDashboard();
        } else { Swal.fire('Error', data.message, 'error'); }
    } catch (error) {
        console.error('Error:', error);
        Swal.fire('Error', 'Error de conexión', 'error');
    }
}

async function gestionarPermisos(id, nombre) {
    if (!tienePermisoAvanzado) {
        Swal.fire('Error', 'No tiene permisos para esta acción', 'error');
        return;
    }
    const modal = document.getElementById('modalPermisosUsuario');
    if (!modal) {
        console.error('Error: El elemento modal "modalPermisosUsuario" no fue encontrado en el DOM.');
        Swal.fire('Error de Interfaz', 'No se pudo encontrar el modal de permisos. Verifique los permisos de usuario.', 'error');
        return;
    }
    try {
        const form = document.getElementById('formPermisosUsuario');
        form.reset();
        document.getElementById('permisosUserName').textContent = nombre;
        document.getElementById('permisos_usuario_id').value = id;
        document.getElementById('csrf_token_permisos').value = csrfToken;

        const contRol = document.getElementById('permisos-rol-container');
        const contEspecial = document.getElementById('permisos-especiales-container');
        contRol.innerHTML = '<small>Cargando...</small>';
        contEspecial.innerHTML = '<small>Cargando...</small>';
        document.getElementById('permisosUserRole').textContent = 'Cargando...';
        
        const data = await Utils.fetchApi(`/api/empleados_ajax.php?action=obtener_empleado&id=${id}`);
        
        if (data.success) {
            const emp = data.data;
            const permisosDelRol = emp.permisos_del_rol || [];
            const permisosEspeciales = emp.permisos_especiales || [];

            document.getElementById('permisosUserRole').textContent = emp.rol_nombre || 'No asignado';

            let rolHtml = '';
            let especialHtml = '';

            todosLosPermisos.forEach(p => {
                const esPermisoDeRol = permisosDelRol.includes(p.id);

                if (esPermisoDeRol) {
                    rolHtml += `<div class="form-check"><input class="form-check-input" type="checkbox" id="permiso_${p.id}" value="${p.id}" checked disabled><label class="form-check-label" for="permiso_${p.id}">${p.descripcion}</label></div>`;
                } else {
                    const tienePermisoEspecial = permisosEspeciales.includes(p.id);
                    const isChecked = tienePermisoEspecial ? 'checked' : '';
                    especialHtml += `<div class="form-check"><input class="form-check-input" type="checkbox" name="permisos[]" id="permiso_${p.id}" value="${p.id}" ${isChecked}><label class="form-check-label" for="permiso_${p.id}">${p.descripcion}</label></div>`;
                }
            });

            contRol.innerHTML = rolHtml || '<small>Este rol no tiene permisos base asignados.</small>';
            contEspecial.innerHTML = especialHtml || '<small>No hay permisos adicionales disponibles para asignar.</small>';
            
            modal.classList.add('show');
        } else { 
            Swal.fire('Error al cargar datos', data.message, 'error'); 
        }
    } catch (error) {
        console.error('Error al gestionar permisos:', error);
        Swal.fire('Error', 'No se pudieron cargar los permisos del usuario.', 'error');
    }
}

async function handlePermisosSubmit(e) {
    e.preventDefault();
    try {
        Utils.mostrarLoading('Guardando permisos...');
        const formData = new FormData(this);
        const data = await Utils.fetchApi('/api/empleados_ajax.php', { method: 'POST', body: formData });
        Swal.close();
        ocultarModal('modalPermisosUsuario');
        if (data.success) { 
            Swal.fire('¡Éxito!', data.message, 'success'); 
        } else { 
            Swal.fire('Error', data.message, 'error'); 
        }
    } catch (error) {
        Swal.close();
        console.error('Error:', error);
        Swal.fire('Error', 'Error de conexión', 'error');
    }
}
</script>

<?php include_once 'templates/footer.php'; ?>