<?php
require_once 'includes/seguridad.php';

if (!puede('ver_agendamiento_global')) {
    header("Location: dashboard.php");
    exit();
}

$jornada_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$jornada_id) {
    header('Location: agendamiento.php');
    exit();
}

$page_title = 'Detalles de Agendamiento';
include_once 'templates/header.php';
?>

<style>
/* --- ESTILOS PARA LOS COLORES DE ESTADO EN LA TABLA --- */
.status-row.agendado { background-color: rgba(108, 117, 125, 0.15) !important; }
.status-row.en-consultorio { background-color: rgba(13, 202, 240, 0.15) !important; }
.status-row.atendido { background-color: rgba(25, 135, 84, 0.2) !important; }
.status-row.no-asistio { background-color: rgba(255, 193, 7, 0.15) !important; }
.status-row.cancelado { background-color: rgba(220, 53, 69, 0.15) !important; }
/* --------------------------------------------------------- */

.ami-table tbody tr:hover { background-color: rgba(var(--primary-color-rgb), 0.25) !important; }
#info-jornada { margin-bottom: 1rem; padding-bottom: 1rem; border-bottom: 2px solid var(--border-color); }
#info-jornada h1 { margin-bottom: 0; }
#info-jornada small { font-size: 1.1rem; opacity: 0.8; }
.update-spinner { display: none; margin-left: 15px; color: var(--primary-color); }
.update-spinner.is-updating { display: inline-block; animation: spin 1s linear infinite; }
@keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }

.paciente-info .cedula-sexo { font-size: 0.85em; opacity: 0.7; display: block; margin-top: 4px; }
.items-list { list-style-type: none; padding-left: 0; margin-bottom: 0; font-size: 0.9em; }
.items-list li { background: rgba(0,0,0,0.2); padding: 2px 8px; border-radius: 4px; margin-bottom: 4px; display: inline-block; border: 1px solid rgba(255,255,255,0.1); }
.items-list strong { color: var(--primary-color); }
</style>

<div class="main-header">
    <div>
        <a href="agendamiento.php" class="btn btn-outline-light mb-3"><i class="fa-solid fa-arrow-left"></i> Volver al Dashboard</a>
        <div id="info-jornada">
            <h1 id="jornada-ciudad">Cargando...</h1>
            <small id="jornada-fecha-ruta"></small>
        </div>
        <h4 id="total-agendados"></h4>
    </div>
    <div>
        <i id="update-indicator" class="fa-solid fa-sync update-spinner" title="Actualizando datos..."></i>
    </div>
</div>

<div class="info-card">
    <div class="table-responsive">
        <table class="ami-table">
            <thead>
                <tr>
                    <th style="width: 50px;">#</th>
                    <th>Paciente</th>
                    <th style="width: 120px;">Estado</th>
                    <th>Teléfono</th>
                    <th>Campaña</th>
                    <th>Exámenes y Medicamentos</th>
                    <th>Notas</th>
                    <th>Agendado por</th>
                </tr>
            </thead>
            <tbody id="pacientes-table-body">
                <tr><td colspan="8" class="text-center">Cargando pacientes agendados...</td></tr>
            </tbody>
        </table>
    </div>
</div>

<?php include_once 'templates/footer.php'; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const jornadaId = <?php echo $jornada_id; ?>;
    const tableBody = document.getElementById('pacientes-table-body');
    const infoCiudad = document.getElementById('jornada-ciudad');
    const infoFechaRuta = document.getElementById('jornada-fecha-ruta');
    const totalAgendados = document.getElementById('total-agendados');
    const updateIndicator = document.getElementById('update-indicator');
    let updateInterval;

    function getStatusClass(status) {
        if (!status) return '';
        return 'status-row ' + status.toLowerCase().replace(' ', '-').replace('í', 'i');
    }

    function actualizarTabla() {
        if (document.activeElement.tagName === 'INPUT' || document.activeElement.tagName === 'TEXTAREA') {
            return;
        }
        updateIndicator.classList.add('is-updating');

        fetch(`/api/agendamiento_ajax.php?action=get_detalles_jornada_agendada&id=${jornadaId}`)
            .then(response => response.ok ? response.json() : Promise.reject('Error de red'))
            .then(data => {
                if (!data.success) throw new Error(data.message);

                const jornada = data.data.info;
                const pacientes = data.data.pacientes;

                infoCiudad.textContent = jornada.ciudad_nombre;
                const fecha = new Date(jornada.fecha_jornada + 'T00:00:00');
                const fechaFormateada = fecha.toLocaleDateString('es-ES', { year: 'numeric', month: 'long', day: 'numeric' });
                infoFechaRuta.textContent = `Ruta: ${jornada.nombre_ruta} | Fecha: ${fechaFormateada}`;
                totalAgendados.textContent = `Total Agendados: ${pacientes.length}`;
                tableBody.innerHTML = '';

                if (pacientes.length === 0) {
                    tableBody.innerHTML = '<tr><td colspan="8" class="text-center">No hay pacientes agendados para esta jornada.</td></tr>';
                } else {
                    pacientes.forEach((p, index) => {
                        const statusClass = getStatusClass(p.estado_cita);
                        const sexo = p.sexo === 'M' ? 'Masculino' : (p.sexo === 'F' ? 'Femenino' : 'N/E');

                        let itemsHtml = '';
                        if (p.examenes && p.examenes.length > 0) {
                            itemsHtml += '<ul class="items-list">';
                            p.examenes.forEach(ex => {
                                itemsHtml += `<li><strong>Examen:</strong> ${ex.nombre_examen} ($${parseFloat(ex.precio || 0).toFixed(2)})</li>`;
                            });
                            itemsHtml += '</ul>';
                        }
                        
                        if (p.medicamentos && p.medicamentos.length > 0) {
                            if (itemsHtml === '') itemsHtml += '<ul class="items-list">';
                            p.medicamentos.forEach(med => {
                                itemsHtml += `<li><strong>Med:</strong> ${med.nombre_medicamento} (x${med.cantidad})</li>`;
                            });
                            if (!itemsHtml.endsWith('</ul>')) itemsHtml += '</ul>';
                        }

                        if (itemsHtml === '') itemsHtml = 'Ninguno';

                        const row = `
                            <tr class="${statusClass}">
                                <td>${index + 1}</td>
                                <td>
                                    <div class="paciente-info">
                                        ${p.paciente_nombre || 'N/A'}
                                        <span class="cedula-sexo">
                                            C.I: ${p.cedula || 'N/A'} | Sexo: ${sexo}
                                        </span>
                                    </div>
                                </td>
                                <td>${p.estado_cita || 'N/A'}</td>
                                <td>${p.telefono || 'N/A'}</td>
                                <td>${p.campana || 'N/D'}</td>
                                <td>${itemsHtml}</td>
                                <td>${p.notas_coordinador || ''}</td>
                                <td>${p.operador_nombre || 'No especificado'}</td>
                            </tr>
                        `;
                        tableBody.innerHTML += row;
                    });
                }
            })
            .catch(error => {
                console.error("Error al actualizar detalles:", error);
                tableBody.innerHTML = `<tr><td colspan="8" class="text-center text-danger">Error al cargar los datos: ${error.message}</td></tr>`;
                if (updateInterval) clearInterval(updateInterval); 
            })
            .finally(() => {
                setTimeout(() => updateIndicator.classList.remove('is-updating'), 500);
            });
    }

    actualizarTabla();
    updateInterval = setInterval(actualizarTabla, 60000); 
});
</script>